/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices.projectors;

import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Json;

public abstract class ProjectorDevice
extends DeviceProfile {
    protected Socket _socket;
    protected OutputStream _outputStream;
    protected InputStream _inputStream;
    protected String _ipAddress;
    protected int _port;

    protected ProjectorDevice(Json json) {
        super(json);
        try {
            this._ipAddress = this._paramsJson.getString("IpAddress");
            if (this._paramsJson.containsKey("Port)")) {
                this._port = this._paramsJson.getInt("Port");
            }
            LOG.info(String.format("ipAddress: %s, port: %d", this._ipAddress, this._port));
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public abstract byte[] getCommandBytes(Json var1);

    public void ensureStreams() throws IOException {
        if (null == this._outputStream || null == this._inputStream) {
            String commType = this._paramsJson.getString("CommType");
            System.out.println("commType = " + commType);
            if ("".equals(commType)) {
                LOG.info(String.format("connecting to %s (%s:%d)", this.Name, this._ipAddress, this._port));
                this._socket = new Socket(this._ipAddress, this._port);
                this._outputStream = this._socket.getOutputStream();
                this._inputStream = this._socket.getInputStream();
            }
        }
    }

    public void send(byte[] bytes) throws Exception {
        int retries;
        int n = retries = null != this._socket ? 1 : 0;
        while (0 <= retries) {
            try {
                this.ensureStreams();
                if (null == this._socket) break;
                this._socket.getOutputStream().write(bytes);
                this._socket.getOutputStream().flush();
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.close();
                if (0 == retries) {
                    throw ex;
                }
                --retries;
            }
        }
    }

    public void close() throws Exception {
        try {
            LOG.info(String.format("closing %s", this.Name));
            if (null != this._inputStream) {
                this._inputStream.close();
                this._inputStream = null;
            }
            if (null != this._outputStream) {
                this._outputStream.close();
                this._outputStream = null;
            }
            if (null != this._socket) {
                this._socket.close();
                this._socket = null;
            }
        }
        catch (Exception ex) {
            this._socket = null;
            throw ex;
        }
    }
}

