/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices.soundprocessors;

import com.integ.tasker.devices.soundprocessors.SoundProcessorDevice;
import java.util.Json;

public class USLJsd100
extends SoundProcessorDevice {
    public USLJsd100(Json json) {
        super(json);
        System.out.println("_port = " + this._port);
        if (0 == this._port) {
            this._port = 10001;
        }
    }

    @Override
    public byte[] getCommandBytes(Json actionParamsJson) {
        String deviceAction = actionParamsJson.getString("DeviceAction");
        System.out.printf("soundprocessorsend device action: %s", new Object[]{deviceAction});
        String commandString = "";
        switch (deviceAction) {
            case "master-mute": {
                commandString = "jsd100.sys.mute\t1\r";
                break;
            }
            case "master-unmute": {
                commandString = "jsd100.sys.mute\t0\r";
                break;
            }
            case "system-fader-set": {
                int level = actionParamsJson.getInt("Level");
                commandString = String.format("jsd100.sys.fader\t%d\r", level *= 100);
                break;
            }
            case "system-fader-adjust": {
                double adjustment = actionParamsJson.getDouble("Adjustment");
                adjustment *= adjustment;
                commandString = String.format("jsd100.sys.fader\t%d\r", (int)adjustment);
            }
        }
        return commandString.getBytes();
    }

    public String toString() {
        return String.format("USL JSD-100 %s:%d", this._ipAddress, this._port);
    }
}

