/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules.rules;

import com.integ.tasker.schedules.Schedule;
import com.integ.tasker.schedules.rules.DateRuleBase;
import java.util.Json;

public class DailyDateRule
extends DateRuleBase {
    private final int _dateRecurranceInterval;

    public DailyDateRule(Json dateOptionsJson) {
        super(dateOptionsJson);
        this._dateRecurranceInterval = dateOptionsJson.getInt("DateRecurranceInterval");
        Schedule.LOG.info(String.format("dateRecurranceInterval: %s", this._dateRecurranceInterval));
    }

    @Override
    public long getNextValidDayStart(long time) {
        long nextValidDayStart = time;
        long daysSinceStartDate = (System.currentTimeMillis() - this._startDate.getTime()) / 86400000L;
        int mod = (int)(daysSinceStartDate % (long)this._dateRecurranceInterval);
        if (0 != mod) {
            nextValidDayStart += (long)mod * 86400000L;
        }
        return nextValidDayStart;
    }
}

