/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalDeviceOrder;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import java.io.IOException;

public abstract class ExternalModule {
    protected static final SensorPort SENSOR_PORT = new SensorPort();
    protected static QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("yyyy-MM-dd HH:mm:ss zzz");
    public long Address;
    public String AddressString;
    public int TypeIndex;
    public String TypeString;
    public long LastReadTime;
    public long LastWriteTime;
    protected byte[] _dataBlock;
    protected byte[] _savedDataBlock;
    protected boolean _hasChanged = false;
    protected static String[] _externalDevices;

    protected ExternalModule(long address, int index, String typeString) {
        this.setAddress(address);
        if (0 > index) {
            index = ExternalDeviceOrder.getIndexForAddress(this.AddressString);
            System.out.println(this.AddressString + " index is now " + index);
        }
        this.TypeIndex = index;
        this.TypeString = typeString + "_" + index;
    }

    private void setAddress(long address) {
        this.Address = address;
        this.AddressString = "0000000000000000" + Long.toHexString(address);
        this.AddressString = this.AddressString.substring(this.AddressString.length() - 16);
        this.AddressString = this.AddressString.toUpperCase();
    }

    public long getMinReadInterval() {
        return 0L;
    }

    protected boolean checkForChange() {
        if (null == this._savedDataBlock || this._dataBlock.length != this._savedDataBlock.length) {
            this._savedDataBlock = new byte[this._dataBlock.length];
        }
        if (!ArrayUtils.arrayComp((Object)this._dataBlock, (int)0, (Object)this._savedDataBlock, (int)0, (int)this._dataBlock.length)) {
            ArrayUtils.arraycopy((Object)this._dataBlock, (int)0, (Object)this._savedDataBlock, (int)0, (int)this._dataBlock.length);
            this._hasChanged = true;
        }
        System.out.println(this.toString() + " changed: " + this._hasChanged);
        return this._hasChanged;
    }

    public boolean hasChanged() {
        return this._hasChanged;
    }

    public abstract void read() throws Throwable;

    public abstract void commit() throws IOException;

    public byte[] getDataBlock() {
        return this._dataBlock;
    }

    public abstract void printValues();

    public float getPercent(int raw) {
        return (float)((double)raw / 65535.0);
    }

    public float scaleValue(int raw, double min, double max) {
        double percent = (double)raw / 65535.0;
        return (float)(percent * (max - min) + min);
    }

    public abstract Object get(String var1);

    public boolean isPresent() {
        String presentDevices = ExternalDeviceOrder.getPresentDevices();
        boolean isPresent = presentDevices.contains(this.AddressString);
        return isPresent;
    }
}

