/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.scripting.objects.ReferenceObject;
import com.integ.tasker.tasks.Scope;
import java.text.DecimalFormat;

public class StringObject
extends AbstractObjectCall {
    private static final DecimalFormat DEFAULT = new DecimalFormat("0.00");

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            if (!parser.nextToken().checkType(46)) {
                throw new UnexpectedTokenException(".", parser.currentToken());
            }
            if (!parser.nextToken().checkType(0)) {
                throw new UnexpectedTokenException("FIELD OR METHOD NAME", parser.currentToken());
            }
            switch (this._fieldOrMethodName = parser.currentToken().content) {
                case "formatdecimal": {
                    this.parseArguments(parser);
                    break;
                }
                case "frombytes": {
                    this.parseArguments(parser);
                    break;
                }
                default: {
                    throw new ScriptParserException(String.format("unknown field or method: %s", this._fieldOrMethodName));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ScriptParserException("unable to process StringObject", ex);
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        switch (this._fieldOrMethodName) {
            case "formatdecimal": {
                double number = Double.valueOf(((AbstractNode)this._arguments.get(0)).execute(scope).toString());
                DecimalFormat decimalFormat = DEFAULT;
                if (2 <= this._arguments.size()) {
                    String formatString = ((AbstractNode)this._arguments.get(1)).toString();
                    decimalFormat = new DecimalFormat(formatString);
                }
                return decimalFormat.format(number);
            }
            case "frombytes": {
                ReferenceObject referenceObject = (ReferenceObject)this._arguments.get(0);
                byte[] bytes = (byte[])referenceObject.execute(scope);
                return new String(bytes);
            }
        }
        return null;
    }
}

