function parseDimmerControlAction(json) {
    var method = json.Method;

    switch (method) {
        case 'SetLEDChannel':
            return new SetLEDChannel();

        case 'SetLEDRGB':
            return new SetLEDRGB();

        case 'FadeLEDChannel':
            return new FadeLEDChannel();

        case 'FadeLEDRGB':
            return new FadeLEDRGB();

        default:
            throw new Error('Unknown Lighting Method: ' + JSON.stringify(json, null, 2));
    }
}



class DimmerControlAction extends Action {
    constructor() {
        super();
        this.Type = 'DimmerControl';
        this.Method = 'void';
        this.Params = {};
    }
}



class SetLEDChannel extends DimmerControlAction {
    constructor(channel, percent) {
        super();
        this.Method = 'SetLEDChannel';
        this.Params.Channel = channel;
        this.Params.Percent = percent;
    }

    editTemplate() {
        var template = 'Set LED Dimmer Channel <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Channel" data-toggle="tooltip" title="Dimmer Channel" style="width:75px;"> ' +
            'to <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Percent" data-toggle="tooltip" title="0 - 100%" style="width:75px;">%';
        return template;
    }
}



class SetLEDRGB extends DimmerControlAction {
    constructor(moduleIndex, red, green, blue) {
        super();
        this.Method = 'SetLEDRGB';
        this.Params.ModuleIndex = moduleIndex;
        this.Params.Red = red;
        this.Params.Green = green;
        this.Params.Blue = blue;
    }

    editTemplate() {
            // var template = 'Set Dimmer RGB for Module Index <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ModuleIndex" data-toggle="tooltip" title="Dimmer Module Index"> ' +
            // 'to <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Red" data-toggle="tooltip" title="RED = 0 - 100%">' +
            // ' <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Green" data-toggle="tooltip" title="GREEN = 0 - 100%">' +
            // ' <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Blue" data-toggle="tooltip" title="BLUE = 0 - 100%">';
            var template = 'Set Dimmer RGB for Module Index <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ModuleIndex" data-toggle="tooltip" title="Dimmer Module Index" style="width:75px;"> ' +
            'to Red: <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Red" data-toggle="tooltip" title="0 - 100%" style="width:75px;">%' +
            ' Green: <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Green" data-toggle="tooltip" title="0 - 100%" style="width:75px;">%' +
            ' Blue: <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Blue" data-toggle="tooltip" title="0 - 100%" style="width:75px;">%';
        return template;
    }
}



class FadeLEDChannel extends DimmerControlAction {
    constructor(channel, percent, duration) {
        super();
        this.Method = 'FadeLEDChannel';
        this.Params.Channel = channel;
        this.Params.Percent = percent;
        this.Params.Duration = duration;
    }

    editTemplate() {
        var template = 'Fade LED Dimmer Channel <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Channel" data-toggle="tooltip" title="Dimmer Channel" style="width:75px;"> ' +
            ' to <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Percent" data-toggle="tooltip" title="0 - 100%" style="width:75px;">%' +
            ' over <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Duration" data-toggle="tooltip" title="seconds" style="width:75px;"> seconds';
        return template;
    }
}



class FadeLEDRGB extends DimmerControlAction {
    constructor(moduleIndex, red, green, blue, duration) {
        super();
        this.Method = 'FadeLEDRGB';
        this.Params.ModuleIndex = moduleIndex;
        this.Params.Red = red;
        this.Params.Green = green;
        this.Params.Blue = blue;
        this.Params.Duration = duration;
    }

    editTemplate() {
        var template = 'Fade Dimmer RGB for Module Index <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ModuleIndex" data-toggle="tooltip" title="Dimmer Module Index" style="width:75px;"> ' +
            'to Red: <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Red" data-toggle="tooltip" title="0 - 100%" style="width:75px;">%' +
            ' Green: <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Green" data-toggle="tooltip" title="0 - 100%" style="width:75px;">%' +
            ' Blue: <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Blue" data-toggle="tooltip" title="0 - 100%" style="width:75px;">%' +
            ' over <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Duration" data-toggle="tooltip" title="seconds" style="width:75px;"> seconds';
        return template;
    }
}