TaskerApp.controller('TaskerController',
    function ($scope, $location, $sce, $compile,
        WorkspaceFileService, TaskService, DeviceService, SignalService,
        TriggerService, ScheduleService, LoggerService) {

        var _this = this;

        _this.DaysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];

        _this.WebVersion = APP.getVersion();
        _this.Version = 'not running';
        _this.IsRunning = false;

        _this.Workspaces = [];
        _this.Workspace = null;
        _this.WorkspaceLastModified = 0;

        _this.knownDevices = [];
        _this.Signals = [];
        _this.Devices = [];
        _this.Config = {
            Version: _this.WebVersion,
            TaskList: [],
            DevicesList: [],
            ScheduleList: [],
            SignalList: [],
            TriggerList: [],
            LoggerList: []
        };
        _this.SavedConfig = angular.copy(_this.Config);

        _this.SaveDialog = null;
        _this.CancelDialog = null;
        _this.ConfigurationExternallyChangedDialog = null;

        _this.log = [];



        _this.getLog = function () {
            var log = _this.log.join('<br>');
            if ("" === log) log = "EMPTY";
            return $sce.trustAsHtml(log);
        };



        _this.showLog = function () {
            var template = '<div ng-bind-html="tasker.getLog()"></div>';
            var linkFn = $compile(template);
            var html = linkFn($scope);

            _this.logDialog = bootbox.dialog({
                className: 'fullscreen bb-primary text-log',
                title: "Log",
                message: html,
                size: 'large',
                onEscape: function () {
                    _this.logDialog.modal('hide');
                }
            });
            _this.logDialog.init(function () {
                $compile(_this.logDialog.contents())($scope);
            });
        };



        _this.getJson = function (json) {

            if (undefined == json || null == json) {
                json = _this.Config;
            }

            return JSON.stringify(json, function replacer(key, value) {
                // remove $$hashKey object as well as references to a parent
                if ('$$hashKey' === key || 'Parent' === key) {
                    return;
                }
                // remove any empty objects.
                if ('Err' === key) { //{} == value) {
                    return;
                }
                return value;
            }, 2);
        };



        _this.new = function () {
            _this.Workspace = '';
            _this.Config = {
                Version: _this.WebVersion,
                TaskList: [],
                DevicesList: [],
                ScheduleList: [],
                SignalList: [],
                TriggerList: [],
                LoggerList: []
            };
            _this.parseConfig(_this.Config);
            $location.search('workspace', undefined);
            $location.search('view', undefined);
        };



        _this.close = function () {
            // check if there are currently changes being made
            var changesInProgress = _this.hasChanged();
            if (changesInProgress) {
                bootbox.alert({
                    title: "There are changes in progress",
                    message: "Sorry.  You cannot switch tabs while there are currently changes in progress.  The changes must either be saved or cancelled."
                }).init(function () {
                    $(".modal-header").css("background-color", "#f0ad4c");
                    $(".modal-header").css("color", "#fff");
                });

            } else {
                _this.new();
                _this.Workspace = undefined;
                $scope.$apply();
            }
        };



        _this.open = function (workspaceName) {
            // before requestiong the new config lets unload the current config.
            _this.new();

            $location.search('workspace', workspaceName);
            _this.load();
        };



        _this.isWorkspaceDisabled = function () {
            if (null == _this.Workspace) return false;
            var disabled = (_this.Workspace.startsWith('#'));
            return disabled;
        };



        _this.configReceived = function (result) {
            if ('Fail' !== result.Status) {
                var filename = result.File;
                var fileContents = Base64.decode(result.Data);
                var configJson = JSON.parse(fileContents);
                _this.parseConfig(configJson);
            }
        };



        _this.parseConfig = function (configJson) {
            try {
                // we are about to load.  invalidate our saved workspace modification time
                console.log('resetting the saved last modified time for ' + _this.Workspace);
                _this.WorkspaceLastModified = 0;

                _this.Config.TaskList = TaskService.load(configJson.TaskList);
                _this.Config.DeviceList = DeviceService.load(configJson.DeviceList);
                _this.Config.ScheduleList = ScheduleService.load(configJson.ScheduleList);
                _this.Config.SignalList = SignalService.load(configJson.SignalList);
                _this.Config.TriggerList = TriggerService.load(configJson.TriggerList);
                _this.Config.LoggerList = LoggerService.load(configJson.LoggerList);

                _this.SavedConfig = angular.copy(_this.Config);

                // broadcast to any listeners that the workspace was loaded locally
                $scope.$broadcast('workspace.loaded', {});
                
            } catch (err) {
                console.error(err);
            }

            // only call scope.apply if needed
            if (!$scope.$$phase) {
                $scope.$apply();
            }

            setTimeout(function () {
                onresize();
                $('[data-toggle="tooltip"]').tooltip();
            }, 100);
        };



        _this.View = null;

        // watch for changes to our $location.url() object.
        $scope.$watch(function () {
            return $location.url();
        }, function (url) {
            if (url) {
                var view = $location.search().view;
                if (view) {
                    _this.setView(view);
                } else {
                    _this.setView(null);
                }

                var workspaceName = $location.search().workspace;
                if (undefined != workspaceName && _this.Workspace != workspaceName) {
                    _this.Workspace = workspaceName;
                    _this.WorkspaceLastModified = 0;
                    JnrWebsocket.readFile('/flash/tasker/workspaces/' + workspaceName, _this.configReceived);
                }
            }
        });


        _this.CurrentService = TaskService;

        // push the view selection to our $location.url() object.
        _this.setView = function (view) {
            if (_this.View == view) return;

            // chack to see if the current service is valid before switching tabs
            var valid = true;
            if (_this.CurrentService && null != _this.CurrentService && _this.CurrentService != TaskService) {
                valid = _this.CurrentService.validate();
            }
            if (!valid) return;

            // check if there are currently changes being made
            // DEBUG
            // seeing if testing for changes is necessary
            var changesInProgress = false; // _this.hasChanged();
            if (changesInProgress) {
                bootbox.alert({
                    title: "There are changes in progress",
                    message: "Sorry.  You cannot switch tabs while there are currently changes in progress.  The changes must either be saved or cancelled."
                }).init(function () {
                    $(".modal-header").css("background-color", "#f0ad4c");
                    $(".modal-header").css("color", "#fff");
                });

            } else {
                _this.View = view;
                if (null != view) {
                    if (null === _this.View || "tasks" === _this.View) {
                        _this.CurrentService = TaskService;
                        onresize();
                    } else if ("device-profiles" === _this.View) {
                        _this.CurrentService = DeviceService;
                    } else if ("signal-profiles" === _this.View) {
                        _this.CurrentService = SignalService;
                    } else if ("trigger-profiles" === _this.View) {
                        _this.CurrentService = TriggerService;
                    } else if ("schedule" === _this.View) {
                        _this.CurrentService = ScheduleService;
                    } else if ("logging-profiles" === _this.View) {
                        _this.CurrentService = LoggerService;
                    }

                    $location.search('view', view);
                    _this.load();

                }
            }
        };


        _this.activateView = function (ele) {
            $compile(ele.contents())($scope);
            $scope.$apply();
        };



        _this.getWorkspaceFiles = function () {
            JnrWebsocket.getFileListing('/flash/tasker/workspaces')
                .then(function (response) {
                    response.Content = response.Content.filter(function (element) {
                        return element.Name.endsWith('.json');
                    });
                    response.Content.sort(function (a, b) {
                        return a.Name.toLowerCase().localeCompare(b.Name.toLowerCase());
                    });
                    _this.Workspaces = response.Content;
                    $scope.$apply();

                    _this.Workspaces.forEach(function (workspace) {
                        if (workspace.Name === _this.Workspace) {
                            _this.checkForExternalWorkspaceModifycation(workspace);
                        }
                    });

                });
        };



        _this.JniorTimeOffset = -1;
        setInterval(function () {
            if (-1 != _this.JniorTimeOffset) {
                var timestamp = new Date().getTime() + _this.JniorTimeOffset;
                _this.JniorTime = moment(timestamp).format('MMMM Do YYYY, h:mm:ss a');
                $scope.$apply();
            } else {
                _this.JniorTime = '';
            }
        }, 750);



        JnrWebsocket.addOnLoggedInListener(function (json) {
            var jniorCurrentTimestamp = json.Timestamp;
            _this.JniorTimeOffset = jniorCurrentTimestamp - new Date().getTime();

            // get the workspace files on load and periodically
            _this.getWorkspaceFiles();
            setInterval(_this.getWorkspaceFiles, 30000);

            JnrWebsocket.readRegistryKeys(['ipconfig/hostname', '$LastNtpSuccess'], function (key, value) {
                if ('$LastNtpSuccess' == key) _this.LastNtpSuccess = value;
                else if ('ipconfig/hostname' == key) document.title = "Tasker - " + value;
                $scope.$apply();
            });

            _this.load();
        });




        _this.workspaceFileUploadRequest = function () {
            if (_this.hasChanged(_this.Config, _this.SavedConfig)) {
                _this.SaveDialog = bootbox.dialog({
                    className: 'bb-primary',
                    title: "Changes have been made to Unsaved Workspace",
                    message: "Changes have been made to the current worksapce.  Proceeding to " +
                        "upload a new workspace will close the current workspace and open the " +
                        "new workspace.  Changes would be lost.  How do you wish to proceed?",
                    buttons: {
                        cancel: {
                            label: 'Cancel',
                            className: 'btn-default'
                        },
                        saveAndContinue: {
                            label: 'Continue Anyway',
                            className: 'btn-warning',
                            callback: function () {
                                _this.workspaceFileUpload();
                            }
                        },
                        continue: {
                            label: 'Save and Continue',
                            className: 'btn-success',
                            callback: function () {
                                _this.save(function () {
                                    _this.workspaceFileUpload();
                                });
                            }
                        }
                    },
                });

            } else {
                _this.workspaceFileUpload();
            }
        };



        _this.workspaceFileUpload = function () {
            var $uploadFile = $('#workspace-file-upload');
            var fileCtrl = $uploadFile[0];
            fileCtrl.onchange = function (evt) {
                var file = evt.target.files[0];
                WorkspaceFileService.uploadFile(file);
            };
            fileCtrl.click();
        };



        var lastAnnouncementTime = new Date().getTime() - 10000;
        JnrWebsocket.addOnMessageListener(function (json) {
            console.log(JSON.stringify(json, null, 2));

            if ('status.update' == json.Message) {
                var title = "";
                if (undefined != status.Title) title += ' : ' + status.Title;
                toastr.success(json.StatusMessage, new Date() + title);

                // now push the message to our log object so we can recall it later
                _this.log.push(moment().format('MM/DD/YY h:mm:ss a') + ', ' + title + ' - ' + json.StatusMessage);
                $scope.$apply();

            }

            else if ('workspace.loaded' == json.Message) {
                var workspaceName = json.WorkspaceName;
                var loadTimeInSeconds = json.LoadTime;
                toastr.success('<b>' + workspaceName + '</b> was Loaded in <b>' + loadTimeInSeconds.toFixed(2) + '</b> seconds');

                // only enable the TasksLoaded if the workspace that Tasker loaded in the one that 
                // the user currently has loaded
                if (workspaceName == _this.Workspace) TaskService.TasksLoaded = true;

                // now push the message to our log object so we can recall it later
                _this.log.push(moment().format('MM/DD/YY h:mm:ss a') + ', ' + workspaceName + ' was Loaded in ' + loadTimeInSeconds.toFixed(2) + ' seconds');
                $scope.$apply();

            }

            else if ('error' == json.Message) {
                var message = json.StackTrace ? json.StackTrace.replaceAll('\r\n', '<br>') : '';
                toastr.error(message, json.ErrorMessage, { closeButton: true, timeOut: 10000, extendedTimeOut: 0 });

                // now push the json object to our log object so we can recall it later
                _this.log.push(moment().format('MM/DD/YY h:mm:ss a') + ' : ' + json.ErrorMessage + ' - ' + message);
                $scope.$apply();

            }

            else if ('announce' == json.Message) {
                lastAnnouncementTime = new Date().getTime();

                if (null != taskerNotRunningToast) {
                    toastr.clear(taskerNotRunningToast);
                    taskerNotRunningToast = null;
                }

                _this.IsRunning = true;
                _this.Version = json.Version;
                $scope.$apply();

            }

            else if (json.Message === "File List Response") {
                if (json.Folder.endsWith(_this.Workspace)) {
                    _this.checkForExternalWorkspaceModifycation(json.Content[0]);
                }
            }

        });
        ``


        _this.checkForExternalWorkspaceModifycation = function (workspace) {
            if (0 == _this.WorkspaceLastModified) {
                console.log('Set the last modified time for ' + _this.Workspace + ' to ' + workspace.Mod);
                _this.WorkspaceLastModified = workspace.Mod;
            } else {
                console.log('saved last modified time for ' + _this.Workspace + ' is ' + _this.WorkspaceLastModified + ' and is now ' + workspace.Mod);
                if (_this.WorkspaceLastModified !== workspace.Mod) {
                    if (!_this.ConfigurationExternallyChangedDialog) {
                        _this.ConfigurationExternallyChangedDialog = bootbox.alert({
                            title: "Configuration externally changed!",
                            message: "Some other process has changed the <b>'" + _this.Workspace + "'</b> configuration since the last time it was " +
                                "loaded.  You could relead the page or your changes will overwrite the configuration.",
                            buttons: {
                                ok: {
                                    label: 'OK',
                                    className: 'btn-danger'
                                }
                            }
                        });
                        _this.ConfigurationExternallyChangedDialog.init(function () {
                            $(".modal-header").css("background-color", "#d9534f");
                            $(".modal-header").css("color", "#fff");
                        });

                        _this.WorkspaceLastModified = workspace.Mod;
                    }
                }
            }
        };



        JnrWebsocket.connect();
        JnrWebsocket.postMessage(2010, { Message: 'announce.request' });



        var taskerNotRunningToast = null;
        setInterval(function () {
            var now = new Date().getTime();
            var elapsed = now - lastAnnouncementTime;
            // console.log('elapsed: ' + elapsed)
            if (15000 < elapsed) {
                if (null == taskerNotRunningToast) {
                    TaskService.TasksLoaded = false;
                    _this.IsRunning = false;
                    $scope.$apply();

                    taskerNotRunningToast = toastr.error("Unable to communicate with the Tasker application", "Tasker is not running", { closeButton: false, timeOut: 0, extendedTimeOut: 0 });
                } else {
                    JnrWebsocket.postMessage(2010, { Message: 'announce.request' });
                }
            }
        }, 1000);



        _this.load = function (callback) {
            setTimeout(function () {
                JnrWebsocket.readFile('/flash/tasker/workspaces/' + _this.Workspace, callback);
            }, 100);
        };



        _this.getHtmlSafe = function (content) {
            if (content) {
                var safeHtml = content.replaceAll('\n', '<br>');
                return $sce.trustAsHtml(safeHtml);
            }
        };



        _this.getHtmlSafeActions = function (signal) {
            if (signal.Actions) {
                var safeHtml = signal.Actions.replaceAll('\n', '<br>');
                return $sce.trustAsHtml(safeHtml);
            }
        };



        _this.hasChanged = function (config, savedConfig) {
            var hasChanged = !angular.equals(_this.Config, _this.SavedConfig);
            if (hasChanged) {
                addEventListener("beforeunload", beforeUnloadListener, { capture: true });
            } else {
                removeEventListener("beforeunload", beforeUnloadListener, { capture: true });
            }
            return hasChanged;
        };



        _this.schemaUpdated = function (file) {
            var fileSchemaArray = file.Schema.split(',');
            file.Schema = fileSchemaArray;
        };



        _this.saveChangesRequest = function () {
            // lets validate the form before saving
            var valid = true;
            if (_this.CurrentService && null != _this.CurrentService) {
                valid = _this.CurrentService.validate();
            }

            if (valid) {
                _this.SaveDialog = bootbox.confirm({
                    title: "Are you sure you want to save your changes?",
                    message: "Your changes will take affect without needing to reboot.",
                    buttons: {
                        cancel: {
                            label: 'Cancel',
                            className: 'btn-default'
                        },
                        confirm: {
                            label: 'Save',
                            className: 'btn-success'
                        }
                    },
                    callback: function (result) {
                        if (result) {
                            TaskService.TasksLoaded = false;
                            $scope.$apply();
                            _this.saveChanges();
                            return false;
                        }
                    }
                });
                _this.SaveDialog.init(function () {
                    $(".modal-header").css("background-color", "#5cb85c");
                    $(".modal-header").css("color", "#fff");
                    $("#bootbox-confirm-btn").prop('disabled', false);
                    $("#bootbox-cancel-btn").prop('disabled', false);
                    confirm_on_enter($(".bootbox"));
                });

            } else {
                bootbox.alert({
                    title: 'Validation Error',
                    message: 'There was an error during validation.  Please check the fields in red and try again'
                }).init(function () {
                    $(".modal-header").css("background-color", "#f0ad4e");
                    $(".modal-header").css("color", "#fff");
                });
            }

        };



        _this.saveAsChangesRequest = function () {
            // lets validate the form before saving
            var valid = true;
            if (_this.CurrentService && null != _this.CurrentService) {
                valid = _this.CurrentService.validate();
            }

            if (valid) {
                _this.SaveDialog = bootbox.prompt({
                    title: "Please enter the new name for the workspace",
                    // message: "Your changes will take affect without needing to reboot.",
                    buttons: {
                        cancel: {
                            label: 'Cancel',
                            className: 'btn-default'
                        },
                        confirm: {
                            label: 'Save',
                            className: 'btn-success'
                        }
                    },
                    value: _this.Workspace.replaceAll('.json', ''),
                    callback: function (result) {
                        if (result) {
                            if (!result.endsWith('.json')) {
                                result += '.json';
                            }
                            _this.Workspace = result;
                            TaskService.TasksLoaded = false;
                            $scope.$apply();
                            _this.saveChanges();

                            // update the url to contain the new workspace name
                            $location.search('workspace', result);

                            return false;
                        }
                    }
                });
                _this.SaveDialog.init(function () {
                    $(".modal-header").css("background-color", "#5cb85c");
                    $(".modal-header").css("color", "#fff");
                    $("#bootbox-confirm-btn").prop('disabled', false);
                    $("#bootbox-cancel-btn").prop('disabled', false);
                    validate_alphanumeric($(".bootbox-input"));
                    confirm_on_enter($(".bootbox"));
                });

            } else {
                bootbox.alert({
                    title: 'Validation Error',
                    message: 'There was an error during validation.  Please check the fields in red and try again'
                }).init(function () {
                    $(".modal-header").css("background-color", "#f0ad4e");
                    $(".modal-header").css("color", "#fff");
                });
            }

        };



        _this.saveComplete = function () {
            if (null !== _this.SaveDialog) {
                _this.SaveDialog.modal('hide');
                _this.SaveDialog = null;
            }

            // make sure to get the updated workspace files with this new filename
            _this.getWorkspaceFiles();

            _this.SavedConfig = angular.copy(_this.Config);
            $scope.$apply();

            var fullWorkspaceFileName = "/flash/tasker/workspaces/" + _this.Workspace;
            JnrWebsocket.postMessage(2010, { Message: 'config.updated', Workspace: fullWorkspaceFileName });
        };



        _this.saveChanges = function () {
            if (null != _this.Workspace && '' != _this.Workspace) {
                $("#bootbox-confirm-btn").html("Saving...");
                $("#bootbox-confirm-btn").prop('disabled', true);
                $("#bootbox-cancel-btn").prop('disabled', true);

                // we are about to save.  invalidate our saved workspace modification time
                console.log('resetting the saved last modified time for ' + _this.Workspace);
                _this.WorkspaceLastModified = 0;

                // perform the save
                _this.save(_this.saveComplete);

            } else {
                _this.saveAsChangesRequest();
            }
        };



        _this.save = function (saveCompleteCallback) {
            // write the saved config to a backup file
            var workspaceFileName = "/flash/tasker/workspaces/" + _this.Workspace;

            var bakFileContent = _this.getJson(_this.SavedConfig);
            // call the writeFile method for the bak copy and only when the file has been 
            //  successfully written will we issue the write file for the save of the 
            //  current changes
            JnrWebsocket.writeFile(workspaceFileName + '.bak', bakFileContent, function () {
                var fileContent = _this.getJson();
                JnrWebsocket.writeFile(workspaceFileName, fileContent, saveCompleteCallback);
            });
        };



        _this.cancelChangesRequest = function () {
            _this.CancelDialog = bootbox.confirm({
                title: "Are you sure you want to cancel your changes?",
                message: "Cancelling your changes will reload the last saved settings",
                buttons: {
                    cancel: {
                        label: 'Keep Changes',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Discard Changes',
                        className: 'btn-warning'
                    }
                },
                callback: function (result) {
                    if (result) {
                        _this.cancelChanges();
                        return false;
                    }
                }
            });
            _this.CancelDialog.init(function () {
                $(".modal-header").css("background-color", "#f0ad4e");
                $(".modal-header").css("color", "#fff");
                $("#bootbox-confirm-btn").prop('disabled', false);
                $("#bootbox-cancel-btn").prop('disabled', false);
            });
        };



        _this.cancelComplete = function () {
            if (null !== _this.CancelDialog) {
                _this.CancelDialog.modal('hide');
                _this.CancelDialog = null;
            }

            _this.Config = angular.copy(_this.SavedConfig);
            $scope.$apply();
        };



        _this.cancelChanges = function () {
            $("#bootbox-confirm-btn").html("Reverting...");
            $("#bootbox-confirm-btn").prop('disabled', true);
            $("#bootbox-cancel-btn").prop('disabled', true);

            _this.load(_this.cancelComplete);
        };



        _this.editWorkspaceName = function () {
            _this.EditWorkspaceNameDialog = bootbox.prompt({
                title: "Please enter the new name for the workspace",
                message: "<p>Any changes that are in progress will not be saved at this time.</p>",
                buttons: {
                    cancel: {
                        label: 'Cancel',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Save',
                        className: 'btn-success'
                    }
                },
                value: _this.Workspace.replaceAll('.json', ''),
                callback: function (result) {
                    if (result) {
                        if (!result.endsWith('.json')) {
                            result += '.json';
                        }

                        // rename the workspace on the jnior
                        var oldWorkspaceFileName = "/flash/tasker/workspaces/" + _this.Workspace;
                        var newWorkspaceFileName = "/flash/tasker/workspaces/" + result;
                        JnrWebsocket.renameFile(oldWorkspaceFileName, newWorkspaceFileName);

                        _this.Workspace = result;
                        $scope.$apply();

                        // update the url to contain the new workspace name
                        $location.search('workspace', result);

                        _this.getWorkspaceFiles();
                    }
                }
            });
            _this.EditWorkspaceNameDialog.init(function () {
                $(".modal-header").css("background-color", "#5cb85c");
                $(".modal-header").css("color", "#fff");
                $("#bootbox-confirm-btn").prop('disabled', false);
                $("#bootbox-cancel-btn").prop('disabled', false);
                validate_alphanumeric($(".bootbox-input"));
                submit_on_enter($(".bootbox"));
            });
        };



        _this.renameWorkspace = function (newName) {
            // get the new file names for the workspace and rename both the .json file and the 
            //  .json.bak file
            var oldWorkspaceFileName = "/flash/tasker/workspaces/" + _this.Workspace;
            var newWorkspaceFileName = "/flash/tasker/workspaces/" + newName;
            JnrWebsocket.renameFile(oldWorkspaceFileName + ".bak", newWorkspaceFileName + ".bak");
            JnrWebsocket.renameFile(oldWorkspaceFileName, newWorkspaceFileName);

            // get the new workspace list
            _this.getWorkspaceFiles();
            _this.Workspace = newName;
            $scope.$apply();

            JnrWebsocket.postMessage(2010, { Message: 'config.updated', Workspace: newWorkspaceFileName });

            // update the url to contain the new workspace name
            $location.search('workspace', newName);
        };



        _this.disableWorkspace = function () {
            var newName = '#' + _this.Workspace;
            // rename the workspace on the jnior
            _this.renameWorkspace(newName);

            onresize();
        };



        _this.enableWorkspace = function () {
            var newName = _this.Workspace.substring(_this.Workspace.indexOf("#") + 1);
            // rename the workspace on the jnior
            _this.renameWorkspace(newName);

            onresize();
        };



        _this.restoreRequest = function () {
            _this.RestoreDialog = bootbox.confirm({
                className: 'bb-primary',
                title: "Are you sure you want to restore the backup version of the " + _this.Workspace + " workspace?",
                // message: '<p>This dialog will present all of the bakup files.  It will show you the ' +
                //     'last modified time and if there is a newer version of the file in progress.  ' +
                //     'You can select a file to have it restored to a non backed up version</p>' +
                //     '<table class="table"><tr><th></th><th>File Name</th><th>Last Modified</th></tr>' +
                //     '<tr><td><input type="checkbox"></td><td>File 1</td><td>Apr 16 2019 16:08</td></tr></table>' +
                //     '<tr><td><input type="checkbox"></td><td>File 2</td><td>Apr 16 2019 16:08</td></tr></table>' +
                //     '<tr><td><input type="checkbox"></td><td>File 3</td><td>Apr 16 2019 16:08</td></tr></table>' +
                //     '<p class="alert alert-danger">This feature is not yet implemented</p>',
                message: '<p>Are you sure you want to restore the backup version of the <b>' + _this.Workspace + '</b> workspace?</p>' +
                    '<p>The previous version of this file was last modified on <b>Apr 16 2019 16:08</b></p>' +
                    '<p class="alert alert-danger">This feature is not yet implemented</p>',
                buttons: {
                    cancel: {
                        label: 'Nevermind',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Restore the Workspace',
                        className: 'btn-primary'
                    }
                },
                callback: function (result) {
                    if (result) {
                        // return false;
                    }
                }
            });
            _this.RestoreDialog.init(function () {
                $("#bootbox-confirm-btn").prop('disabled', true);
                $("#bootbox-cancel-btn").prop('disabled', false);
            });
        };



        _this.deleteRequest = function () {
            _this.DeleteDialog = bootbox.confirm({
                className: 'bb-primary',
                title: "Are you sure you want to delete the " + _this.Workspace + " workspace?",
                message: '<p>Are you sure you want to delete the <b>' + _this.Workspace + '</b> workspace?</p>' +
                    '<p>Deleting the workspace will make a backup copy of the workspace and ' +
                    'delete the current version.  This will prevent the workspace logic from ' +
                    'running and allow you to restore if you change your mind later.<p>',
                buttons: {
                    cancel: {
                        label: 'Ah! Nevermind',
                        className: 'btn-danger'
                    },
                    confirm: {
                        label: 'Delete the Workspace',
                        className: 'btn-primary'
                    }
                },
                callback: function (result) {
                    if (result) {
                        // write the saved config to a backup file
                        var workspaceFileName = "/flash/tasker/workspaces/" + _this.Workspace;

                        var bakFileContent = _this.getJson(_this.SavedConfig);
                        JnrWebsocket.writeFile(workspaceFileName + '.bak', bakFileContent);

                        // now delete the json file for this workspace
                        JnrWebsocket.removeFile(workspaceFileName).then(function () {
                            JnrWebsocket.postMessage(2010, { Message: 'config.updated' });

                            _this.getWorkspaceFiles();

                            bootbox.alert({
                                className: 'bb-primary',
                                title: 'Workspace Removed!',
                                message: '<p><b>' + _this.Workspace + '</b> has been deleted!</p><p>But ' +
                                    'dont worry.  A <b>backup</b> has been created for you to ' +
                                    '<b>restore</b> from later!</p>'
                            });

                            _this.close();
                        });
                    }
                }
            });
        };



        _this.showPreferences = function () {
            var template = '<div ng-include="\'preferences.html\'"></div>';
            var linkFn = $compile(template);
            var html = linkFn($scope);

            bootbox.dialog({
                className: 'bb-primary',
                title: "Preferences",
                message: html,
                buttons: {
                    cancel: {
                        label: 'Cancel',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Set',
                        className: 'btn-success',
                        callback: function (result) {
                            if (result) {
                                var form = $("#preferences-form");
                                form.validate({ errorPlacement: function (error, element) { } });

                                if (form.valid()) {
                                    // if (undefined == schedule.Params) schedule.Params = {};
                                    // if (undefined == schedule.Params.Rules) schedule.Params.Rules = [];
                                    // schedule.Params.Rules.push(_this.SelectedRule);

                                    // $scope.$apply();
                                } // else return false;
                            }
                        }
                    }
                }
            });
        };



        ///////////////////////////////////////////////////////



        _this.fileNameChange = function (filename) {
            if (filename) {
                alert(filename);
            }
        };


        var lastFocused;
        _this.setLastFocused = function ($event) {
            if (!$event) {
                lastFocused = null;
            } else if (lastFocused !== $event.currentTarget) {
                lastFocused = $event.currentTarget;
            }
        };

        _this.shouldInsertType = function () {
            return lastFocused && (null !== lastFocused);
        };

        _this.isModulePresent = function (signal) {
            var moduleId = null;
            for (var deviceIndex in _this.Devices) {
                if (_this.Devices[deviceIndex].Type === signal.Type) {
                    moduleId = _this.Devices[deviceIndex].Id;
                }
            }

            var modulePresent = false;
            if (null !== moduleId) {
                modulePresent = _this.knownDevices[moduleId];
            }

            return modulePresent;
        };

        _this.insertText = function (text) {
            insertText(lastFocused, text);
        };



        _this.getDownloadUri = function (uri) {
            if (null != _this.Workspace) {
                var htmlSafeWorkspaceName = _this.Workspace.replaceAll('#', '%23');
                var uri = 'download.php?filename=/flash/tasker/workspaces/'
                    + htmlSafeWorkspaceName + '&download=' + htmlSafeWorkspaceName;
                return uri;
            }
            return '';
        };



        const beforeUnloadListener = (event) => {
            event.preventDefault();
            return event.returnValue = "Are you sure you want to exit?";
        };
    });


var fileNameTarget = null;
var fileNameScope = null;

TaskerApp.directive('filenameChange', function () {
    return function (scope, element, attrs) {
        element.bind("keydown keyup", function (event) {
            var target = event.target;
            console.log("keyup: " + event.which);
            console.log("scope " + scope);
            // did the user press '{'
            if (event.which === 219) {
                var selectionStart = target.selectionStart;
                console.log("selectionStart: " + selectionStart);
                if (1 < selectionStart) {
                    // check to see if the typed character and the previous character make "{{"
                    var value = target.value;
                    console.log("value: " + value);
                    var substr = value.substring(selectionStart - 2, selectionStart);
                    console.log("substr: " + substr);
                    if ("{{" === substr) {
                        fileNameTarget = target;
                        fileNameScope = scope;
                        showFileNameOptions();
                    }
                }

            } else if ("keydown" === event.type && event.which === 112) {

                var selectionStart = target.selectionStart;
                console.log("selectionStart: " + selectionStart);
                var prevLeftCurlyBrace = target.value.lastIndexOf("{{", selectionStart);
                console.log("prevLeftCurlyBrace: " + prevLeftCurlyBrace);
                var prevRightCurlyBrace = target.value.lastIndexOf("}}", selectionStart);
                console.log("prevRightCurlyBrace: " + prevRightCurlyBrace);
                var nextLeftCurlyBrace = target.value.indexOf("{{", selectionStart);
                console.log("nextLeftCurlyBrace: " + nextLeftCurlyBrace);
                var nextRightCurlyBrace = target.value.indexOf("}}", selectionStart);
                console.log("nextRightCurlyBrace: " + nextRightCurlyBrace);

                if ((prevLeftCurlyBrace > prevRightCurlyBrace) && -1 !== nextRightCurlyBrace && (-1 === nextLeftCurlyBrace || nextRightCurlyBrace < nextLeftCurlyBrace)) {
                    fileNameTarget = target;
                    fileNameScope = scope;
                    showFileNameOptions();
                }

                event.preventDefault();
            }
        });
    };
});



TaskerApp.service('WorkspaceFileService', function ($location) {
    var _service = this;

    _service.uploadFile = function (file) {
        if (file) {
            if (file.size > 102400) {
                bootbox.alert("Selected file is too large");
                return;
            }

            bootbox.confirm({
                className: 'bb-primary',
                title: "Are you sure you want to load the selected file?",
                message: "Are you sure you want to upload the '" + file.name + "' workspace?",
                buttons: {
                    cancel: {
                        label: 'No',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Yes',
                        className: 'btn-primary'
                    }
                },
                callback: function (result) {
                    if (result) {
                        var r = new FileReader();
                        r.onload = function (e) {
                            var contents = e.target.result;

                            try {
                                // make sure the filename does not contain spaces
                                var filename = file.name.replaceAll(' ', '_');
                                var fullname = "/flash/tasker/workspaces/" + filename;

                                JnrWebsocket.writeFile(fullname, contents, function () {
                                    bootbox.alert({
                                        className: 'bb-success',
                                        title: 'Upload Success!',
                                        message: '<b>' + file.name + "</b> uploaded as <b>" + fullname + '</b>'
                                    });

                                    $location.search('workspace', file.name);
                                });

                                // also alert out java application that the new file should be ready to consume.
                                JnrWebsocket.postMessage(2010, { Message: 'config.updated', fullname });
                            } catch (e) {
                                alert("Failed uploading the file" + e.toString());
                                return false;
                            }
                            return true;
                        };
                        r.readAsText(file);
                    }
                }
            });
        }
    };

}
);