/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.resettypes;

import com.integ.scripting.exceptions.DeviceNotPresentException;
import com.integ.scripting.objects.EnvironObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.FourTwentyOutputObject;
import com.integ.scripting.objects.TempProbeObject;
import com.integ.scripting.objects.TenVoltInputObject;
import com.integ.scripting.objects.TenVoltOutputObject;
import com.integ.tasker.Unloadable;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.triggers.Reset;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.logger.AppLog;
import java.util.Json;

public class ContinuousSignalReset
extends Reset
implements Unloadable {
    private final Json _paramsJson;
    private final String _signalProfileName;
    private final String _resetState;
    private SignalProfile _signalProfile;
    private final String _resetComparator;
    private final double _resetValue;
    private double _lastValue = -1.0;

    public ContinuousSignalReset(Json resetJson) {
        this._paramsJson = (Json)resetJson.get("Params");
        this._resetState = this._paramsJson.getString("State");
        Json resetSignalJson = (Json)this._paramsJson.get("Signal");
        this._signalProfileName = resetSignalJson.getString("Name");
        this._resetComparator = this._paramsJson.getString("Comparator");
        this._resetValue = this._paramsJson.getDouble("Value");
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
        SignalProfilesCollection signalProfilesCollection = workspaceConfigurationFile.getSignalProfilesCollection();
        if (signalProfilesCollection.containsSignalProfileName(this._signalProfileName)) {
            this._signalProfile = signalProfilesCollection.getByName(this._signalProfileName);
        }
    }

    @Override
    public void checkForReset() throws Throwable {
        if (!this._trigger.isTriggered()) {
            return;
        }
        String deviceType = this._signalProfile.DeviceType;
        int channel = this._signalProfile.Channel;
        String fieldName = this._signalProfile.FieldName;
        String deviceString = String.format("%s[%d].%s", deviceType, channel, fieldName);
        double value = Double.NaN;
        try {
            Object result;
            if ("type28".equalsIgnoreCase(deviceType)) {
                result = TempProbeObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("vin".equalsIgnoreCase(deviceType)) {
                result = TenVoltInputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("vout".equalsIgnoreCase(deviceType)) {
                result = TenVoltOutputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("iin".equalsIgnoreCase(deviceType)) {
                result = FourTwentyInputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("iout".equalsIgnoreCase(deviceType)) {
                result = FourTwentyOutputObject.read(channel, fieldName);
                value = (Double)result;
            } else if ("type7e".equalsIgnoreCase(deviceType)) {
                result = EnvironObject.read(channel, fieldName);
                value = (Double)result;
            }
        }
        catch (DeviceNotPresentException ex) {
            AppLog.warn(ex.getMessage());
            Thread.sleep(10000L);
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
        if (this._lastValue != value) {
            this._lastValue = value;
            System.out.println(String.format("ContinuousSignalReset for %s: %.3f %s %.3f", deviceString, value, this._resetComparator, this._resetValue));
        }
        switch (this._resetComparator) {
            case "<": {
                this._isReset = value < this._resetValue;
                break;
            }
            case "<=": {
                this._isReset = value <= this._resetValue;
                break;
            }
            case "=": {
                this._isReset = value == this._resetValue;
                break;
            }
            case ">": {
                this._isReset = value > this._resetValue;
                break;
            }
            case ">=": {
                boolean bl = this._isReset = value >= this._resetValue;
            }
        }
        if (this._isReset) {
            System.out.println(this + " reseted!");
            this.resetTrigger();
        }
    }

    @Override
    public void unload() {
    }
}

