/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules;

import com.integ.tasker.schedules.Schedule;
import com.integ.tasker.schedules.ScheduleCollection;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Json;

public class ScheduleConfiguration {
    private static final Logger LOG = FileLog.getHalfBackupLog(new LogOptions(Application.getAppName() + "_schedules.log"));
    private final WorkspaceFile _workspaceConfigurationFile;
    private final TaskCollection _taskCollection = new TaskCollection();

    public ScheduleConfiguration(WorkspaceFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public void loadConfiguration(Json[] scheduleListJsonArray) throws Throwable {
        ScheduleCollection.clear();
        if (null == scheduleListJsonArray || 0 == scheduleListJsonArray.length) {
            return;
        }
        for (Json scheduleJson : scheduleListJsonArray) {
            LOG.info("scheduleJson: " + scheduleJson);
        }
        for (Json scheduleJson : scheduleListJsonArray) {
            Schedule schedule = new Schedule(scheduleJson, this._workspaceConfigurationFile);
            ScheduleCollection.put(schedule);
        }
    }
}

