/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.http.server;

import com.integpg.janoslib.http.HttpConnection;
import com.integpg.janoslib.http.server.HttpListener;
import com.integpg.janoslib.http.server.HttpRequest;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.net.TcpServer;
import com.integpg.janoslib.net.TcpServerEvent;
import com.integpg.janoslib.net.TcpServerListener;
import com.integpg.janoslib.system.Application;
import java.text.DecimalFormat;
import java.util.Vector;

public class HttpServer
extends TcpServer
implements TcpServerListener {
    private static final Logger WebServerLog = FileLog.getLog(new LogOptions(Application.getAppName() + "_webserver.log"));
    private Vector<HttpListener> _listeners = new Vector();
    private final DecimalFormat DF = new DecimalFormat("0.000");

    public HttpServer(int port) {
        super("HttpServer", port);
        super.setTcpServerListener(this);
    }

    @Override
    public void start() {
        super.start();
        WebServerLog.info("HttpServer started");
    }

    public void addListener(HttpListener httpListener) {
        this._listeners.addElement(httpListener);
    }

    @Override
    public void clientConnected(final TcpServerEvent evt) {
        System.out.println(String.format("%lld client connected", System.currentTimeMillis()));
        new Thread(){

            @Override
            public void run() {
                try {
                    HttpConnection httpConnection = new HttpConnection(evt.getSocket());
                    long start = System.currentTimeMillis();
                    HttpRequest httpRequest = new HttpRequest(httpConnection);
                    httpRequest.processRequest();
                    if (null != httpRequest.getRequest()) {
                        for (int i = 0; i < HttpServer.this._listeners.size(); ++i) {
                            HttpListener httpListener = (HttpListener)HttpServer.this._listeners.elementAt(i);
                            httpListener.requestRecieved(httpRequest);
                        }
                        long elapsed = System.currentTimeMillis() - start;
                        WebServerLog.info(String.format("took %.3f seconds to process %s from %s", (double)elapsed / 1000.0, httpRequest.getRequest(), httpConnection.getRemoteAddress()));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.start();
    }

    public void log(String string) {
        WebServerLog.info(string);
    }

    static {
        WebServerLog.info("--------------------------------------------------");
    }
}

