/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.iolog;

import com.integpg.janoslib.iolog.IoChannelLogListener;
import com.integpg.janoslib.iolog.IoLogListener;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.system.IoEvent;
import com.integpg.system.Iolog;
import com.integpg.system.JANOS;
import java.util.ArrayList;

public abstract class IoLogMonitor
implements Runnable {
    protected static final Logger LOG = Logger.getLogger("temp/" + Application.getAppName() + "_iologmonitor.log");
    protected static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss.fff");
    protected final Iolog _iolog = new Iolog();
    protected final ArrayList<IoLogListener> _ioLogEventListeners = new ArrayList();
    protected final ArrayList<IoChannelLogListener> _ioChannelLogEventListeners = new ArrayList();
    private Thread _thd;
    private long _refreshTimestamp;
    protected static IoEvent _lastIoEvent;
    private boolean _initialCheck = true;

    protected IoLogMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Iolog iolog = this._iolog;
        synchronized (iolog) {
            if (null == this._thd) {
                this._thd = new Thread(this);
                this._thd.setName(this.getClass().getName());
                this._thd.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIoLogEventListener(IoLogListener ioLogEventListener) {
        this._ioLogEventListeners.add(ioLogEventListener);
        Iolog iolog = this._iolog;
        synchronized (iolog) {
            if (null == this._thd) {
                this.start();
            }
        }
    }

    public void removeIoLogEventListener(IoLogListener ioLogEventListener) {
        this._ioLogEventListeners.remove(ioLogEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIoChannelLogEventListener(IoChannelLogListener digitalOutputsLogListener) {
        this._ioChannelLogEventListeners.add(digitalOutputsLogListener);
        Iolog iolog = this._iolog;
        synchronized (iolog) {
            if (null == this._thd) {
                this.start();
            }
        }
    }

    public void removeIoChannelLogEventListener(IoChannelLogListener digitalOutputsLogListener) {
        this._ioChannelLogEventListeners.remove(digitalOutputsLogListener);
    }

    public void setRefreshTimestamp(long refreshTimestamp) {
        this._refreshTimestamp = refreshTimestamp;
    }

    protected abstract IoEvent[] getIoEvents();

    public static IoEvent getLastIoEvent() {
        return _lastIoEvent;
    }

    @Override
    public void run() {
        long _savedSignature = -1L;
        while (true) {
            try {
                while (true) {
                    long signature;
                    if (_savedSignature != (signature = JANOS.getIoSignature())) {
                        _savedSignature = signature;
                        this._iolog.refresh(this._refreshTimestamp);
                        IoEvent[] ioEvents = this.getIoEvents();
                        if (ioEvents.length > 0) {
                            if (1 < ioEvents.length) {
                                LOG.info(ioEvents.length + " events returned since " + QUICK_DATE_FORMAT.format(this._refreshTimestamp));
                            }
                            int errorCount = 0;
                            for (int index = ioEvents.length - 1; index >= 0; --index) {
                                IoEvent ioEvent = ioEvents[index];
                                if (ioEvent.timestamp < this._refreshTimestamp) {
                                    ++errorCount;
                                    continue;
                                }
                                this.alertListenersOfIoEvent(ioEvent);
                            }
                            if (0 != errorCount) {
                                LOG.info("iolog returned " + errorCount + " events earlier than the requested time of " + QUICK_DATE_FORMAT.format(this._refreshTimestamp));
                            }
                            this._refreshTimestamp = ioEvents[0].timestamp;
                            this.alertListenersOfEventsProcessed();
                        } else if (this._initialCheck) {
                            this.alertListenersOfEventsProcessed();
                        }
                        this._initialCheck = false;
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void alertListenersOfIoEvent(IoEvent ioEvent) {
        try {
            long start = System.currentTimeMillis();
            if (null == _lastIoEvent || IoLogMonitor._lastIoEvent.timestamp < ioEvent.timestamp) {
                _lastIoEvent = ioEvent;
            }
            for (IoLogListener ioLogListener : this._ioLogEventListeners) {
                if (null == ioLogListener) continue;
                ioLogListener.onIoEvent(ioEvent);
            }
            long elapsed = System.currentTimeMillis() - start;
            if (100L < elapsed) {
                System.out.println(String.format("process event took %.3f", (double)elapsed / 1000.0));
            }
            this.alertIoChannelListeners(ioEvent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public abstract void alertIoChannelListeners(IoEvent var1);

    private void alertListenersOfEventsProcessed() {
        try {
            for (IoLogListener ioLogListener : this._ioLogEventListeners) {
                if (null == ioLogListener) continue;
                long start = System.currentTimeMillis();
                ioLogListener.onIoEventsProcessed();
                long elapsed = System.currentTimeMillis() - start;
                if (100L >= elapsed) continue;
                System.out.println(String.format("process event took %.3f", (double)elapsed / 1000.0));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

