var app = angular.module('TaskerHelp', []);

app.controller('HelpController', function ($scope, $location, $q, $http, $templateCache) {
    var _this = this;
    _this.order = 'Title';
    _this.search = {};
    _this.search.Category = $location.search()['category'];



    // watch for changes to our $location.url() object.
    $scope.$watch(function () {
        return $location.url();
    }, function (url) {
        if (url) {
            var locationSearch = $location.search();
            var blockId = locationSearch.blockId;
            if (blockId) {
                scrollTo('#' + blockId);
            }
        }
    });



    _this.setOrder = function (order) {
        _this.order = order;
    };

    
    
    _this.getHtml = function (block) {
        return block.Id + '.html';
    };



    _this.scrollTo = function (block) {
        $location.search('blockId', block.Id);
    };



    _this.Blocks = [
        {
            Id: "Syntax", Title: "Conditional Values", Category: "Syntax", Since: "3.0",
        },
        {
            Id: "other-comment", Title: "Other - Comment", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Description", Type: "Text" },
            ]
        },
        {
            Id: "other-commandline", Title: "Other - Command Line", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Command", Type: "Text" },
            ]
        },
        {
            Id: "other-reboot", Title: "Other - Reboot", Category: "Task Actions", Since: "3.0", Arguments: [
            ]
        },
        {
            Id: "other-executetask", Title: "Other - Execute Task", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Task", Type: "Text" },
            ]
        },
        {
            Id: "other-deletefile", Title: "Other - Delete File", Category: "Task Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
            ]
        },
        {
            Id: "other-prependfile", Title: "Other - Prepend File", Category: "Task Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "Added Text", Type: "Text" },
            ]
        },
        {
            Id: "other-copyfile", Title: "Other - Copy File", Category: "Task Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "File Destination", Type: "Text" },
            ]
        },
        {
            Id: "other-movefile", Title: "Other - Move File", Category: "Task Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "File Destination", Type: "Text" },
            ]
        },
        {
            Id: "timing-sleep", Title: "Timing - Sleep", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Duration", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-softinputinvert", Title: "Relay Inputs - Soft Input Invert", Category: "Task Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-resetinputcounter", Title: "Relay Inputs - Reset Input Counter", Category: "Task Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-resetinputusagemeter", Title: "Relay Inputs - Reset Input Usage Meter", Category: "Task Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-closerelay", Title: "Relay Outputs - Close Relay", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-openrelay", Title: "Relay Outputs - Open Relay", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-setrelay", Title: "Relay Outputs - Set Relay State", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "State", Type: "HIGH or LOW" },
            ]
        },
        {
            Id: "relayoutputs-pulserelay", Title: "Relay Outputs - Pulse Relay", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" }
            ]
        },
        {
            Id: "relayoutputs-setrelays", Title: "Relay Outputs - Set Relay States", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channels", Type: "Number Block" },
                { Name: "States", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-pulserelays", Title: "Relay Outputs - Pulse Relay States", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "States", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" }
            ]
        },
        {
            Id: "analogoutputs-set10vpercentage", Title: "Analog Outputs - Set 10v Percentage", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "analogoutputs-set10vvoltage", Title: "Analog Outputs - Set 10v Voltage", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Voltage", Type: "Number Block, can use decimals" },
            ]
        },
        {
            Id: "analogoutputs-set420mapercentage", Title: "Analog Outputs - Set 4-20ma Percentage", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "analogoutputs-set420maamps", Title: "Analog Outputs - Set 4-20ma Amps", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Amps", Type: "Number Block, can use decimals" },
            ]
        },
        {
            Id: "controlstructures-ifblock", Title: "Control Structures - If Block", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "If Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-ifelseblock", Title: "Control Structures - If Else Block", Category: "Task Actions", Since: "3.1", Arguments: [
                { Name: "If Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-loop", Title: "Control Structures - Loop", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Loop Variable", Type: "Text" },
                { Name: "Start Value of Length", Type: "Number Block" },
                { Name: "End Value of Length", Type: "Number Block" },
            ]
        },
        {
            Id: "controlstructures-whileloop", Title: "Control Structures - While Loop", Category: "Task Actions", Since: "3.1", Arguments: [
                { Name: "Loop Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-setvariable", Title: "Control Structures - Set Variable", Category: "Task Actions", Since: "3.1", Arguments: [
                { Name: "Variable", Type: "Text" },
                { Name: "Value", Type: "Text" },
            ]
        },
        {
            Id: "controlpanel-setled", Title: "Control Panel - Set LED", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "LED State", Type: "Drop-Down option" },
            ]
        },
        {
            Id: "controlpanel-playalarm", Title: "Control Panel - Play Alarm", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Alarm Rate", Type: "Drop-Down option" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
                { Name: "Volume Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "controlpanel-silencealarm", Title: "Control Panel - Silence Alarm", Category: "Task Actions", Since: "3.0", Arguments: [
            ]
        },
        {
            Id: "lighting-setdimmerchannel", Title: "Lighting - Set LED Dimmer Channel", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "lighting-setdimmerrgb", Title: "Lighting - Set LED Dimmer RGB", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Dimmer being set", Type: "Number Block" },
                { Name: "Red Percentage", Type: "Number Block" },
                { Name: "Green Percentage", Type: "Number Block" },
                { Name: "Blue Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "lighting-fadedimmerchannel", Title: "Lighting - Fade LED Dimmer Channel", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
            ]
        },
        {
            Id: "lighting-fadedimmerrgb", Title: "Lighting - Fade LED Dimmer RGB", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Dimmer being set", Type: "Number Block" },
                { Name: "Red Percentage", Type: "Number Block" },
                { Name: "Green Percentage", Type: "Number Block" },
                { Name: "Blue Percentage", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
            ]
        },
        {
            Id: "logging-logentry", Title: "Logging - Log Entry", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Text to be Logged", Type: "Text" },
                { Name: "File Path", Type: "Text" },
            ]
        },
        {
            Id: "logging-logprofile", Title: "Logging - Log Profile", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Log Profile being called", Type: "Text" },
            ]
        },
        {
            Id: "network-tcpsend", Title: "Network - Tcp Send", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Device", Type: "Drop-Down Select" },
                { Name: "Info being sent", Type: "Text" },
            ]
        },
        {
            Id: "network-emailsend", Title: "Network - Email Send", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Recipient Email", Type: "Text" },
                { Name: "Email's Subject", Type: "Text" },
                { Name: "Email's Message", Type: "Text" },
            ]
        },
        {
            Id: "network-emailprofilesend", Title: "Network - Email Profile Send", Category: "Task Actions", Since: "3.0", Arguments: [
                { Name: "Email Profile", Type: "Text" },
            ]
        },
        {
            Id: "network-snmptrap", Title: "Network - SNMP Trap", Category: "Task Actions", Since: "3.1", Arguments: [
                { Name: "OID", Type: "Number Block" },
                { Name: "Data", Type: "Text" },
                { Name: "Device", Type: "Drop-Down Select" },
            ]
        },
    ];



    _this.getCategories = function () {
        return ['Task Actions'];
    };

});


