/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting;

import com.integ.scripting.ParseEngine;
import com.integ.tasker.tasks.Scope;

public class ScriptTest {
    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 2; ++i) {
            ScriptTest.testScript("print(\"The current time is: \" + date.format(\"HH:mm:ss.fff\"));");
            ScriptTest.testScript("recv_buffer = \\x23\\x96\\x81\\x01\\x06\\x00\\x01\\x50\\x46\\x00\\x00\\xD8;\r\nlamp_seconds = arrayutils.getint(recv_buffer, 7, true);\r\nprint(\"Lamp usage time is: \" + lamp_seconds);");
            ScriptTest.testScript("module_index = 1;\r\nprint(\"iin[\" + module_index + \"]: \" + iin[module_index].desc + \": \" + iin[module_index].scaled + iin[module_index].units);\r\nmodule_index = 2;\r\nprint(\"iin[\" + module_index + \"]: \" + iin[module_index].desc + \": \" + iin[module_index].scaled + iin[module_index].units);\r\n");
            ScriptTest.testScript("input_channel = 2;\r\nusage_meter = din[2].usagemeter;\r\nmillis_in_hour = 3600000;\r\npercentage = usage_meter / millis_in_hour * 100;\r\npercentage_string = string.formatdecimal(percentage, \"0.000\");\r\nprint(\"the usage time for input \" + input_channel + \" is: \" + usage_meter);\r\nprint(\"that is \" + percentage_string + \"% of an hour\");");
        }
    }

    private static void testScript(String script) {
        try {
            System.out.println("\r\nscript:\r\n" + script);
            ParseEngine parseEngine = new ParseEngine();
            long startParse = System.currentTimeMillis();
            parseEngine.parse(script);
            long elapsedParse = System.currentTimeMillis() - startParse;
            System.out.println(String.format("  elapsed parse %lld", elapsedParse));
            long startExecute = System.currentTimeMillis();
            parseEngine.execute(Scope.getGlobal());
            long elapsedExecute = System.currentTimeMillis() - startExecute;
            System.out.println(String.format("  elapsed execute %lld", elapsedExecute));
            long elapsedTotal = elapsedParse + elapsedExecute;
            System.out.println(String.format("  total elapsed %lld", elapsedTotal));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

