/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tail;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TailMain {
    private static String Filename;
    private static File File;
    private static long Offset;
    private static long SavedLastModifiedTime;

    public static void main(String[] args) throws IOException, InterruptedException {
        boolean monitor = false;
        int numberOfLines = 10;
        block10: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "-f": 
                case "--follow": {
                    monitor = true;
                    continue block10;
                }
                case "-n": 
                case "--lines": {
                    numberOfLines = Integer.parseInt(args[++i]);
                    continue block10;
                }
                default: {
                    Filename = arg;
                }
            }
        }
        if (null == Filename) {
            System.out.println("Must provide filename");
            System.exit(0);
        }
        if (!(File = new File(Filename)).exists()) {
            System.out.println(Filename + " does not exist");
            System.exit(0);
        }
        Offset = File.length();
        SavedLastModifiedTime = File.lastModified();
        byte[] fileBytes = TailMain.readAllBytes(File);
        String fileContent = new String(fileBytes);
        fileContent = TailMain.trimEnd(fileContent, '\n');
        TailMain.printTailNumberOfLines(fileContent, numberOfLines);
        if (monitor) {
            TailMain.monitorFile();
        }
        System.in.skip(System.in.available());
    }

    private static void printTailNumberOfLines(String fileContents, int numberOfLines) throws IOException {
        Offset = File.length();
        int endIndex = (int)Offset;
        boolean bakFileLoaded = false;
        while (0 < numberOfLines--) {
            int startIndex = fileContents.lastIndexOf("\r\n", endIndex - 1);
            if (-1 == startIndex) {
                byte[] fileBytes;
                if (bakFileLoaded) break;
                bakFileLoaded = true;
                File bakFile = new File(Filename + ".bak");
                if (!bakFile.exists() || -1 == (startIndex = (fileContents = new String(fileBytes = TailMain.readAllBytes(bakFile)) + fileContents).lastIndexOf("\r\n", (endIndex += fileBytes.length) - 1))) break;
            }
            endIndex = startIndex;
        }
        System.out.println(fileContents.substring(endIndex));
    }

    private static byte[] readAllBytes(File file) throws IOException {
        return TailMain.readBytes(file.getPath(), 0, (int)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(String filename, int offset, int length) throws IOException {
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(filename, "r");
            in.seek(offset);
            byte[] buf = new byte[length];
            in.read(buf);
            byte[] byArray = buf;
            return byArray;
        }
        catch (Exception ex) {
            System.err.println("Error readng file: " + filename);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
    }

    private static void monitorFile() throws IOException, InterruptedException {
        while (0 == System.in.available()) {
            Thread.sleep(1000L);
            long lastModifiedTime = File.lastModified();
            if (lastModifiedTime == SavedLastModifiedTime) continue;
            long fileSize = File.length();
            if (fileSize < Offset) {
                System.out.println(">>> file reset\r\n");
                Offset = 0L;
            }
            byte[] fileBytes = TailMain.readBytes(Filename, (int)Offset, (int)(fileSize - Offset));
            String fileContent = new String(fileBytes);
            System.out.print(fileContent);
            Offset = fileSize;
            SavedLastModifiedTime = lastModifiedTime;
        }
    }

    public static String trimEnd(String s, char c) {
        int lastIndexPos;
        for (lastIndexPos = s.length(); 0 < lastIndexPos && s.charAt(lastIndexPos - 1) == c; --lastIndexPos) {
        }
        s = s.substring(0, lastIndexPos);
        return s;
    }

    static {
        Offset = 0L;
        SavedLastModifiedTime = 0L;
    }
}

