/*
 * Decompiled with CFR 0.152.
 */
package sunequation;

import com.integ.common.logging.Logger;
import com.integ.common.logging.RollingFileLog;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;

public class MacroSender {
    private static final Logger LOGGER = RollingFileLog.getLogger("SunriseAndSunset.log");
    private final String _ipAddress;
    private final int _portNumber;

    public MacroSender(String ipAddress, int portNumber) {
        this._ipAddress = ipAddress;
        this._portNumber = portNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String macroName) throws IOException {
        String commandString = "run " + macroName;
        LOGGER.info("sending " + commandString + " to " + this._ipAddress + ":" + this._portNumber);
        Socket socket = null;
        FilterOutputStream dataOutputStream = null;
        try {
            socket = new Socket(this._ipAddress, this._portNumber);
            dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.write(commandString.getBytes());
            ((DataOutputStream)dataOutputStream).flush();
            LOGGER.info("Sent Command: '" + commandString + "'");
        }
        catch (Exception ex) {
            LOGGER.error("error sending " + commandString + ".  check cinema and make sure it is running and configured correctly.", ex);
        }
        finally {
            if (null != dataOutputStream) {
                dataOutputStream.close();
            }
            if (null != socket) {
                socket.close();
            }
        }
    }
}

