/*
 * Decompiled with CFR 0.152.
 */
package sunequation;

public class SunEquations {
    private double _sunRise = Double.NaN;
    private double _sunSet = Double.NaN;

    public double getSunrise() {
        return this._sunRise;
    }

    public double getSunset() {
        return this._sunSet;
    }

    public void calculate(int daysPastJan1, double latParsed, double lonParsed) {
        double latitude = latParsed;
        double longitude = lonParsed;
        double J = 2451545.0009 + longitude / 360.0 + (double)daysPastJan1;
        double M = (357.5291 + 0.98560028 * (J - 2451545.0)) % 360.0;
        double C = 1.9148 * Math.sin(this.getRadians(M)) + 0.02 * Math.sin(this.getRadians(2.0 * M)) + 3.0E-4 * Math.sin(this.getRadians(3.0 * M));
        double \u03bb = (M + 102.9372 + C + 180.0) % 360.0;
        double jTransit = J + 0.0053 * Math.sin(this.getRadians(M)) - 0.0069 * Math.sin(this.getRadians(2.0 * \u03bb));
        double newM = 0.0;
        double newC = 0.0;
        double new\u03bb = 0.0;
        for (int i = 0; i < 3; ++i) {
            newM = (357.5291 + 0.98560028 * (jTransit - 2451545.0)) % 360.0;
            newC = 1.9148 * Math.sin(this.getRadians(newM)) + 0.02 * Math.sin(this.getRadians(2.0 * newM)) + 3.0E-4 * Math.sin(this.getRadians(3.0 * newM));
            new\u03bb = (newM + 102.9372 + newC + 180.0) % 360.0;
        }
        double \u03b4 = this.getDegrees(Math.asin(Math.sin(this.getRadians(new\u03bb)) * Math.sin(this.getRadians(23.45))));
        double H = this.getDegrees(Math.acos((Math.sin(this.getRadians(-0.83)) - Math.sin(this.getRadians(latitude)) * Math.sin(this.getRadians(\u03b4))) / (Math.cos(this.getRadians(latitude)) * Math.cos(this.getRadians(\u03b4)))));
        double JJ = 2451545.0009 + (H + longitude) / 360.0 + (double)daysPastJan1;
        this._sunSet = JJ + (0.0053 * Math.sin(this.getRadians(newM)) - 0.0069 * Math.sin(this.getRadians(2.0 * new\u03bb)));
        this._sunRise = jTransit - (this._sunSet - jTransit);
    }

    private double getRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    private double getDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }
}

