/*
 * Decompiled with CFR 0.152.
 */
package sunequation;

import com.integ.common.logging.Logger;
import com.integ.common.logging.RollingFileLog;
import com.integ.common.system.UnitConfig;
import com.integ.common.utils.DateUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Date;
import sunequation.Config;
import sunequation.JulianDateUtils;
import sunequation.MacroSender;
import sunequation.SunEquations;

public class SunEquation {
    private static final Logger LOGGER = RollingFileLog.getLogger("SunriseAndSunset.log");

    public static void main(String[] args) throws IOException, InterruptedException {
        boolean duplicate;
        int runningprocesses = JANOS.registerProcess((String)"SunEquation");
        boolean bl = duplicate = 1 < runningprocesses;
        if (duplicate) {
            System.out.println("duplicate process");
            System.exit(0);
        }
        LOGGER.info("Version 1.1");
        Config.init();
        Double latParsed = Config.getLatitude();
        Double lonParsed = Config.getLongitude();
        if (-1.0 == latParsed) {
            LOGGER.warn("Please enter a valid latitude");
        }
        if (-1.0 == lonParsed) {
            LOGGER.warn("Please enter a valid longitude");
        }
        while (-1.0 == latParsed || -1.0 == lonParsed) {
            latParsed = Config.getLatitude();
            lonParsed = Config.getLongitude();
            Thread.sleep(1000L);
        }
        String ipAddress = UnitConfig.getIpAddress();
        int portNumber = Config.getCinemaServerPort();
        if (portNumber == -1) {
            LOGGER.error("TcpPort number not set properly, closing application.");
            System.exit(0);
        }
        MacroSender macroSender = new MacroSender(ipAddress, portNumber);
        SunEquations sunEquations = new SunEquations();
        sunEquations.calculate(JulianDateUtils.getJulianDate(), latParsed, lonParsed);
        Date sunRise = JulianDateUtils.getDateFromJulianDate(sunEquations.getSunrise());
        Date sunSet = JulianDateUtils.getDateFromJulianDate(sunEquations.getSunset());
        LOGGER.info("Sunrise : " + sunRise);
        LOGGER.info("Sunset: " + sunSet);
        long tomorrowMidnight = DateUtils.getStartOfDay() + 86400000L;
        long lastCheck = System.currentTimeMillis();
        while (true) {
            long now = System.currentTimeMillis();
            if (sunRise.getTime() > lastCheck && sunRise.getTime() <= now) {
                macroSender.send("sunrise");
            }
            if (sunSet.getTime() > lastCheck && sunSet.getTime() <= now) {
                macroSender.send("sunset");
            }
            if (tomorrowMidnight > lastCheck && tomorrowMidnight <= now) {
                tomorrowMidnight = DateUtils.getStartOfDay() + 86400000L;
                sunEquations.calculate(JulianDateUtils.getJulianDate(), latParsed, lonParsed);
                sunRise = JulianDateUtils.getDateFromJulianDate(sunEquations.getSunrise());
                sunSet = JulianDateUtils.getDateFromJulianDate(sunEquations.getSunset());
                LOGGER.info("Sunrise : " + sunRise);
                LOGGER.info("Sunset: " + sunSet);
            }
            Thread.sleep(350L);
            lastCheck = now;
        }
    }
}

