/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp;

import com.integ.common.debug.DEBUG;
import com.integ.common.iolog.DigitalInputsIoLogMonitor;
import com.integ.common.iolog.IoChannelEvent;
import com.integ.common.iolog.IoChannelLogListener;
import com.integ.common.iolog.RelayOutputsIoLogMonitor;
import com.integ.common.logging.AppLog;
import com.integ.common.messagepump.MessagePumpEngine;
import com.integ.common.system.Application;
import com.integ.common.system.ApplicationWatchdog;
import com.integ.common.utils.ApplicationUtils;
import com.integpg.snmp.Agent;
import com.integpg.snmp.AgentInterface;
import com.integpg.snmp.AssemblyInfo;
import com.integpg.snmp.Config;
import com.integpg.snmp.ExternalModuleInteregator;
import com.integpg.snmp.OidReceiveHandler;
import com.integpg.snmp.SNMPStore;
import com.integpg.snmp.TrapReceiveHandler;
import com.integpg.snmp.TrapSender;
import com.integpg.snmp.objects.SNMPObjectIdentifier;
import com.integpg.snmp.objects.SNMPOctetString;
import com.integpg.snmp.objects.SNMPRequestPDU;
import com.integpg.snmp.objects.SNMPVarBindings;
import com.integpg.snmp.objects.SNMPVariablePair;
import com.integpg.snmp.objects.exceptions.SNMPBadValueException;
import com.integpg.system.JANOS;
import java.net.SocketException;
import java.util.Vector;

public class SnmpMain
implements AgentInterface {
    private TrapSender _trapSender;

    public static void main(String[] args) {
        try {
            AssemblyInfo assemblyInfo = new AssemblyInfo();
            Application.init(assemblyInfo);
            ApplicationUtils.exitOnDuplicateInstance(assemblyInfo.getName());
            ApplicationWatchdog applicationWatchdog = new ApplicationWatchdog(0);
            applicationWatchdog.start();
            SnmpMain snmpMain = new SnmpMain();
            snmpMain.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init() {
        try {
            SNMPStore.init();
            Config.init();
            this._trapSender = new TrapSender();
            MessagePumpEngine.addListener(new OidReceiveHandler());
            MessagePumpEngine.addListener(new TrapReceiveHandler(this._trapSender));
            MessagePumpEngine.start();
            DigitalInputsIoLogMonitor digitalInputsIoLogMonitor = new DigitalInputsIoLogMonitor();
            digitalInputsIoLogMonitor.addIoChannelLogEventListener(new IoChannelLogListener(){

                @Override
                public void onIoChannelEvent(IoChannelEvent ioEvent) {
                    String regTrapConfigKey = "IO/Inputs/SnmpTrapMask";
                    int trapConfigMask = JANOS.getRegistryInt((String)regTrapConfigKey, (int)0);
                    regTrapConfigKey = "IO/Inputs/din" + ioEvent.Channel + "/SnmpTrap";
                    boolean enabled = JANOS.getRegistryBoolean((String)regTrapConfigKey, (boolean)false);
                    if (enabled |= (trapConfigMask & 1) == 1) {
                        SnmpMain.this._trapSender.sendTrap(new SNMPObjectIdentifier("1.3.6.1.4.1.31976.1.1.2.1.2." + ioEvent.Channel), SNMPStore.SYSTEM_INPUTS[ioEvent.Channel - 1], "public");
                    }
                }
            });
            digitalInputsIoLogMonitor.start();
            RelayOutputsIoLogMonitor relayOutputsIoLogMonitor = new RelayOutputsIoLogMonitor();
            relayOutputsIoLogMonitor.addIoChannelLogEventListener(new IoChannelLogListener(){

                @Override
                public void onIoChannelEvent(IoChannelEvent ioEvent) {
                    String regTrapConfigKey = "IO/Outputs/SnmpTrapMask";
                    int trapConfigMask = JANOS.getRegistryInt((String)regTrapConfigKey, (int)0);
                    regTrapConfigKey = "IO/Outputs/rout" + ioEvent.Channel + "/SnmpTrap";
                    boolean enabled = JANOS.getRegistryBoolean((String)regTrapConfigKey, (boolean)false);
                    if (enabled |= (trapConfigMask & 1) == 1) {
                        SnmpMain.this._trapSender.sendTrap(new SNMPObjectIdentifier("1.3.6.1.4.1.31976.1.1.4.1.2." + ioEvent.Channel), SNMPStore.SYSTEM_OUTPUTS[ioEvent.Channel - 1], "public");
                    }
                }
            });
            relayOutputsIoLogMonitor.start();
            Agent agent = new Agent();
            agent.setAgentInterface(this);
            agent.listen();
            this.sendBootCompleteTrap();
            ExternalModuleInteregator.start();
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private void sendBootCompleteTrap() {
        this._trapSender.sendTrap(new SNMPObjectIdentifier("1.3.6.1.4.1.31976.1.0.1"), new SNMPOctetString(JANOS.getSerialNumber() + "; Boot Complete (" + JANOS.getPOR() + ")"), "public");
    }

    @Override
    public void processGetRequest(SNMPRequestPDU pdu) throws Exception {
        if (DEBUG.ON) {
            System.out.println("processGetRequest");
        }
        SNMPVarBindings varBindings = pdu.getVarBindings();
        Vector<SNMPVariablePair> pairs = varBindings.getVariablePairs();
        for (int i = 0; i < pairs.size(); ++i) {
            try {
                SNMPVariablePair pair = pairs.elementAt(i);
                if (DEBUG.ON) {
                    System.out.println("pair: " + pair);
                }
                SNMPObjectIdentifier oid = pair.getOID();
                if (DEBUG.ON) {
                    System.out.println("find: " + oid);
                }
                SNMPVariablePair foundPair = SNMPStore.findPair(oid);
                if (DEBUG.ON) {
                    System.out.println("found: " + foundPair);
                }
                if (null == foundPair) {
                    pdu.setErrorIndex(i + 1);
                    pdu.setErrorStatus(2);
                    break;
                }
                pair.setObject(foundPair.getObject());
                continue;
            }
            catch (SNMPBadValueException ex) {
                AppLog.error(ex);
            }
        }
    }

    @Override
    public void processGetNextRequest(SNMPRequestPDU pdu) throws Exception {
        if (DEBUG.ON) {
            System.out.println("processGetNextRequest");
        }
        SNMPVarBindings varBindings = pdu.getVarBindings();
        Vector<SNMPVariablePair> pairs = varBindings.getVariablePairs();
        for (int i = 0; i < pairs.size(); ++i) {
            try {
                SNMPVariablePair pair = pairs.elementAt(i);
                if (DEBUG.ON) {
                    System.out.println("pair: " + pair);
                }
                SNMPObjectIdentifier oid = pair.getOID();
                if (DEBUG.ON) {
                    System.out.println("find: " + oid);
                }
                SNMPVariablePair foundPair = SNMPStore.findNextPair(oid);
                if (DEBUG.ON) {
                    System.out.println("found: " + foundPair);
                }
                if (null == foundPair) {
                    pdu.setErrorIndex(i + 1);
                    pdu.setErrorStatus(2);
                    break;
                }
                varBindings.setPairAt(foundPair, i);
                continue;
            }
            catch (SNMPBadValueException ex) {
                AppLog.error(ex);
            }
        }
    }
}

