/*
 * Decompiled with CFR 0.152.
 */
package com.integ.common.logging;

import com.integ.common.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LogOutputStream
extends OutputStream {
    protected final String _filename;
    protected final File _file;
    protected final File _bakFile;
    protected final int _clusterSize = 4096;
    protected int _maxFileSize = 65536;

    public LogOutputStream(String filename) throws FileNotFoundException {
        this._filename = filename;
        this._file = new File(filename);
        this._bakFile = new File(this._file.getPath() + ".bak");
    }

    public LogOutputStream setMaxSizeKB(int maxSizeKB) {
        this._maxFileSize = maxSizeKB * 1024;
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        throw new RuntimeException("should not call this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        File file = this._file;
        synchronized (file) {
            if (0 != len) {
                int numberOfBytesConsumedInPreWrite = this.preWrite(b, off, len);
                if (0 < numberOfBytesConsumedInPreWrite) {
                    off += numberOfBytesConsumedInPreWrite;
                    len -= numberOfBytesConsumedInPreWrite;
                }
                FileUtils.appendBytes(this._file.getPath(), b, off, len);
                this.postWrite(len);
            }
        }
    }

    protected abstract int preWrite(byte[] var1, int var2, int var3) throws IOException;

    private void postWrite(int len) {
    }

    @Override
    public void flush() {
    }
}

