/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPCodec;
import com.integpg.snmp.objects.SNMPSequence;
import com.integpg.snmp.objects.SNMPVariablePair;
import java.io.IOException;
import java.util.Vector;

public class SNMPVarBindings
extends SNMPSequence {
    private Vector<SNMPVariablePair> _pairs = new Vector();

    @Override
    public int getTag() {
        return 48;
    }

    public Vector<SNMPVariablePair> getVariablePairs() {
        return this._pairs;
    }

    public void addPair(SNMPVariablePair pair) {
        this._pairs.addElement(pair);
    }

    public void setPairAt(SNMPVariablePair pair, int index) {
        this._pairs.removeElementAt(index);
        this._pairs.insertElementAt(pair, index);
    }

    @Override
    public void decodeBER(SNMPCodec codec) throws IOException {
        super.decodeBER(codec);
        int tag = codec.getTag();
        SNMPVariablePair variablePair = new SNMPVariablePair();
        variablePair.decodeBER(codec);
        this._pairs.addElement(variablePair);
    }

    @Override
    public void encodeBER(SNMPCodec codec) throws IOException {
        super.encodeBER(codec);
        for (int i = 0; i < this._pairs.size(); ++i) {
            SNMPVariablePair snmpVariablePair = this._pairs.elementAt(i);
            snmpVariablePair.encodeBER(codec);
        }
    }

    @Override
    public int getLength() {
        int totalLength = 0;
        for (int i = 0; i < this._pairs.size(); ++i) {
            SNMPVariablePair pair = this._pairs.elementAt(i);
            totalLength += pair.getTLVLength();
        }
        this._length = totalLength;
        return this._length;
    }

    @Override
    public String toString() {
        String resultString = "";
        for (int i = 0; i < this._pairs.size(); ++i) {
            resultString = resultString + "         " + this._pairs.elementAt(i);
        }
        return resultString;
    }
}

