/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.snmp.objects;

import com.integpg.snmp.objects.SNMPCodec;
import java.io.IOException;

public abstract class SNMPObject {
    protected int _length;
    private int _tlvLength = -1;

    public abstract int getTag();

    public int getLength() {
        return this._length;
    }

    public abstract Object getValue();

    public int getTLVLength() {
        if (-1 == this._tlvLength) {
            int tlvLength;
            int length = this.getLength();
            this._tlvLength = tlvLength = length + SNMPCodec.bytesNeededForValue(length) + 1;
        }
        return this._tlvLength;
    }

    public void decodeBER(SNMPCodec codec) throws IOException {
        this._length = codec.decodeLength();
    }

    public void encodeBER(SNMPCodec codec) throws IOException {
        codec.write(this.getTag());
        codec.encodeLength(this.getLength());
    }

    public abstract String toString();
}

