/*
 * Decompiled with CFR 0.152.
 */
package com.integ.taskerjson;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.snap.actions.Action;
import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.Scope;
import com.integ.snap.actions.controlstructures.Function;
import com.integ.snap.triggers.Trigger;
import com.integ.taskerjson.SnapsCollection;
import com.integ.taskerjson.messagehandlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.DateUtils;
import com.integpg.janoslib.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Json;

public class StackFile {
    private final File _snapFile;
    private final ArrayList<String> _stackNames = new ArrayList();

    public StackFile(File snapFile) {
        this._snapFile = snapFile;
    }

    public String[] getStacks() {
        return (String[])this._stackNames.toArray();
    }

    public void load() {
        AppLog.info("load " + this._snapFile.getPath());
        long start = DateUtils.now();
        String fileContents = null;
        try {
            fileContents = FileUtils.readAllText(this._snapFile.getPath());
        }
        catch (IOException ex) {
            AppLog.error("error reading " + this._snapFile.getPath(), ex);
        }
        if (null != fileContents) {
            try {
                String jsonString = fileContents;
                Json json = new Json(jsonString);
                Object snaps = json.get("Snaps");
                if (!(snaps instanceof Json)) {
                    Json[] snapsJsonArray = (Json[])json.get("Snaps");
                    System.out.println("snapsJsonArray.length: " + snapsJsonArray.length);
                    for (Json snapJson : snapsJsonArray) {
                        Action action = ActionFactory.getActionClass(Scope.Global, snapJson);
                        if (action instanceof Trigger || !(action instanceof Function)) continue;
                        Function function = (Function)action;
                        System.out.println("Put " + function.getName());
                        this._stackNames.add(function.getName());
                        SnapsCollection.put(function.getName(), action);
                        System.out.println("SnapCollection.size(): " + SnapsCollection.size());
                    }
                }
            }
            catch (Exception ex) {
                Throwable throwable = new Exception("error loading " + this._snapFile.getPath()).initCause(ex);
                AppLog.error(throwable);
                ErrorMessage errorMessage = new ErrorMessage(throwable);
                MessagePumpEngine.postMessage(errorMessage.build());
            }
            long elapsed = DateUtils.now() - start;
            AppLog.info("took " + elapsed + " millis to load " + this._snapFile.getName());
        }
    }
}

