var app = angular.module('HelpApp', []);

app.config(function($locationProvider) {
    $locationProvider.html5Mode(true)
            .hashPrefix('#');
});

app.controller('HelpController', function($scope, $location, $q, $http, $templateCache, $anchorScroll) {
    $scope.order = 'Title';
    $scope.search = {};
    $scope.search.Category = $location.search()['category'];

    $scope.setOrder = function(order) {
        $scope.order = order;
    };

    $scope.getHtml = function(block) {
        return block.Id + '.html';
    };

    $scope.scrollTo = function(block) {
        scrollTo('#' + block.Id);
    };

    $scope.Blocks = [
        {Id: "file-delete", Title: "File - Delete", Category: "Menu", Since: "1.0"},
        {Id: "file-download", Title: "File - Download", Category: "Menu", Since: "1.0"},
        {Id: "file-new", Title: "File - New", Category: "Menu", Since: "1.0"},
        {Id: "file-open", Title: "File - Open", Category: "Menu", Since: "1.0"},
        {Id: "file-samples", Title: "File - Samples", Category: "Menu", Since: "1.0"},
        {Id: "file-save", Title: "File - Save", Category: "Menu", Since: "1.0"},
        {Id: "file-revert", Title: "File - Revert", Category: "Menu", Since: "1.0"},
        {Id: "file-saveas", Title: "File - Save As", Category: "Menu", Since: "1.0"},
        {Id: "file-upload", Title: "File - Upload", Category: "Menu", Since: "1.0"},
        {Id: "log-to", Title: "Log To", Category: "Text", Since: "1.0", Arguments: [
                {Name: "File Name", Type: "Text"},
                {Name: "Child Blocks", Type: "Output Block"}
            ]},
        {Id: "on-input-trigger", Title: "On Input", Category: "Trigger", Since: "1.0", Arguments: [
                {Name: "Channel", Type: "Number Block"},
                {Name: "State", Type: "Drop Down Select"}
            ]},
        {Id: "pulse-output-block", Title: "Pulse Output Block", Category: "Relay Outputs", Since: "1.0", Arguments: [
                {Name: "State Mask", Type: "Text - Number (Decimal or Hexadecimal)"},
                {Name: "Channel Mask", Type: "Text - Number (Decimal or Hexadecimal)"},
                {Name: "Duration", Type: "Text - Number"}
            ]},
        {Id: "schedule-at-trigger", Title: "Schedule At", Category: "Trigger", Since: "1.0", Arguments: [
                {Name: "Hour", Type: "Text - Number"},
                {Name: "Minute", Type: "Text - Number"}
            ]},
        {Id: "set-output-block", Title: "Set Output Block", Category: "Relay Outputs", Since: "1.0", Arguments: [
                {Name: "State Mask", Type: "Text - Number (Decimal or Hexadecimal)"},
                {Name: "Channel Mask", Type: "Text - Number (Decimal or Hexadecimal)"}
            ]},
        {Id: "static-text", Title: "Static Text", Category: "Text", Since: "1.0", Arguments: [
                {Name: "Static Text", Type: "Text"}
            ]},
    ];


    var promises = [];
    $scope.Blocks.forEach(function(element) {
        var promise = $http.get(element.Id + '.html', {cache: $templateCache})
                .then(function() {
                    console.log(element.Id + '.html loaded');
                });
        promises.push(promise);
    });
    $q.all(promises).then(function(data) {
        console.log('All templates are loaded into the cache !');

        if ($location.hash()) {
            setTimeout(function() {
                scrollTo('#' + $location.hash());
            }, 100);
        }
    });


});


