/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.lexer;

public class Token {
    public final int type;
    public String content;
    public int lineNo;
    public int colPos;

    public Token(int t, String c, int lineNo, int colPos) {
        this.type = t;
        this.content = c;
        this.lineNo = lineNo;
        this.colPos = colPos;
    }

    public String toString() {
        if (this.type == 4) {
            return "STRING {{ " + this.content + " }} " + this.lineNo + ":" + this.colPos;
        }
        if (this.type == 0) {
            return "IDENTIFIER {{ " + this.content + " }} " + this.lineNo + ":" + this.colPos;
        }
        if (this.type == 1) {
            return "PUNCTUATOR {{ " + this.content + " }} " + this.lineNo + ":" + this.colPos;
        }
        if (this.type == 3) {
            return "NUMERIC {{ " + this.content + " }} " + this.lineNo + ":" + this.colPos;
        }
        return this.type + " {{ " + this.content.toString() + " }} " + this.lineNo + " " + this.colPos;
    }

    public boolean checkContent(String expected) {
        return this.content.equals(expected);
    }

    public boolean equals(int tokenType) {
        return tokenType == this.type;
    }

    public boolean isLeftBrace() {
        return this.checkContent("{");
    }

    public boolean isRightBrace() {
        return this.checkContent("}");
    }

    public boolean isLeftParen() {
        return this.checkContent("(");
    }

    public boolean isRightParen() {
        return this.checkContent(")");
    }

    public boolean isSemiColon() {
        return this.checkContent(";");
    }

    public boolean isDot() {
        return this.checkContent(".");
    }

    public boolean isComma() {
        return this.checkContent(",");
    }

    public boolean isAssignment() {
        return this.checkContent("=");
    }
}

