/**
 * @license
 * Visual Blocks Editor
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Colour blocks for Blockly.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Blocks.inputs');

goog.require('Blockly.Blocks');


Blockly.Blocks.inputs.HUE = 60;


Blockly.Blocks['monitor_trigger'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Monitor")
            .appendField("     Name:")
            .appendField(new Blockly.FieldTextInput("NAME"), "NAME");
        this.appendValueInput("TRIGGER")
            .setCheck(null)
            .appendField("Trigger Condition");
        this.appendStatementInput("TRIGGER_STATEMENTS")
            .setCheck(null);
        this.setColour(230);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};



Blockly.Blocks['monitor_trigger_reset'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Monitor")
            .appendField("     Name:")
            .appendField(new Blockly.FieldTextInput("NAME"), "NAME");
        this.appendValueInput("TRIGGER")
            .setCheck(null)
            .appendField("Trigger Condition");
        this.appendStatementInput("TRIGGER_STATEMENTS")
            .setCheck(null);
        this.appendValueInput("RESET")
            .setCheck(null)
            .appendField("Reset Condition");
        this.appendStatementInput("RESET_STATEMENTS")
            .setCheck(null);
        this.setColour(230);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};



Blockly.Blocks['inputs_onchange'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("On Input ")
        this.appendValueInput("CHANNEL")
            .setCheck("Number")
            .setAlign(Blockly.ALIGN_RIGHT)
        this.appendDummyInput()
            .appendField(new Blockly.FieldDropdown([["Either", "EITHER"], ["High", "HIGH"], ["Low", "LOW"]]), "STATE");
        this.appendStatementInput("STATEMENTS")
            .setCheck(null);
        this.setColour(Blockly.Blocks.inputs.HUE);
        this.setHelpUrl('help/index.html#on-input-trigger');
    }
};


Blockly.Blocks['inputs_monitor'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Monitor");
        this.appendValueInput("DEVICE")
            .setCheck("Number");
        this.appendStatementInput("TRIGGER")
            .setCheck("Number")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField(new Blockly.FieldDropdown([["Rising Above", "RISING"], ["Fallilg Below", "FALLING"]]), "DIRECTION")
            .appendField("Trigger Value")
            .appendField(new Blockly.FieldTextInput(""), "TRIGGER_SET_POINT");
        this.appendStatementInput("RESET")
            .setCheck("Number")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Reset Value")
            .appendField(new Blockly.FieldTextInput(""), "RESET_SET_POINT");
        this.setInputsInline(true);
        this.setColour(Blockly.Blocks.inputs.HUE);
    }
};


Blockly.Blocks['temperature_value'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Temperature")
            .appendField(new Blockly.FieldDropdown([["Fahrenheit", "FAHRENHEIT"], ["Celcius", "CELCIUS"]]), "UNITS");
        this.appendValueInput("CHANNEL")
            .setCheck("Number")
            .appendField("Channel");
        this.setInputsInline(true);
        this.setOutput(true, "Number");
        this.setColour(310);
    }
};


Blockly.Blocks['input_states'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Input States");
        this.setOutput(true);
        this.setColour(Blockly.Blocks.inputs.HUE);
    }
};


Blockly.Blocks['input_state'] = {
    init: function () {
        this.appendValueInput("CHANNEL")
            .setCheck("Number")
            .appendField("Input");
        this.appendDummyInput()
            .appendField("State");
        this.setOutput(true);
        this.setColour(Blockly.Blocks.inputs.HUE);
    }
};


Blockly.Blocks['input_counter_value'] = {
    init: function () {
        this.appendValueInput("CHANNEL")
            .setCheck("Number")
            .appendField("Input");
        this.appendDummyInput()
            .appendField("Counter Value");
        this.setOutput(true);
        this.setColour(Blockly.Blocks.inputs.HUE);
    }
};


Blockly.Blocks['input_usage_meter_value'] = {
    init: function () {
        this.appendValueInput("CHANNEL")
            .setCheck("Number")
            .appendField("Input");
        this.appendDummyInput()
            .appendField("Usage Meter Value");
        this.setOutput(true);
        this.setColour(Blockly.Blocks.inputs.HUE);
    }
};



Blockly.Blocks['inputs_10volt_scaled'] = {
    init: function () {
        this.appendValueInput("CHANNEL")
            .setCheck("Number")
            .appendField("10 volt Module - Channel");
        this.appendValueInput("MIN")
            .setCheck("Number")
            .appendField("Scale: Min");
        this.appendValueInput("MAX")
            .setCheck("Number")
            .appendField("Max");
        this.setInputsInline(true);
        this.setOutput(true, "Number");
        this.setColour(65);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};






Blockly.Blocks['inputs_4_20_scaled'] = {
    init: function () {
        this.appendValueInput("CHANNEL")
            .setCheck("Number")
            .appendField("4-20ma Module - Channel");
        this.appendValueInput("MIN")
            .setCheck("Number")
            .appendField("Scale: Min");
        this.appendValueInput("MAX")
            .setCheck("Number")
            .appendField("Max");
        this.setInputsInline(true);
        this.setOutput(true, "Number");
        this.setColour(65);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};



Blockly.Blocks['monitor_mqtt'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Monitor MQTT Topic:")
            .appendField(new Blockly.FieldTextInput("NAME"), "NAME");
        this.appendStatementInput("TRIGGER_STATEMENTS")
            .setCheck(null);
        this.setColour(230);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};