/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.ast;

import com.integ.snap.ast.ASTIdentifierNode;
import com.integ.snap.ast.ASTNode;
import com.integ.snap.ast.identifierobjects.IdentifierObject;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import java.util.regex.Pattern;

public class ASTVariableNode
implements ASTNode {
    protected static final Pattern DEVICE_PATTERN = Pattern.compile("([\\w_])+\\[(\\d+)\\]\\.([\\w_]+)");
    protected final String _variableString;

    protected ASTVariableNode(String variableString) {
        this._variableString = variableString;
    }

    public static ASTNode getNode(String variableString) {
        System.out.println("getNode: " + variableString);
        long start = System.currentTimeMillis();
        try {
            Queue<Token> tokenQueue = new Queue<Token>();
            Lexer.parse(tokenQueue, variableString);
            TokenStream tokens = new TokenStream(tokenQueue);
            Token currentToken = tokens.getCurrent();
            if (0 != currentToken.type) {
                throw new RuntimeException("device identifier expected.  found " + currentToken + " instead");
            }
            String identifierNameString = currentToken.content;
            System.out.println("identifierNameString: " + identifierNameString);
            IdentifierObject identifierObject = IdentifierObject.getIdentifierObject(identifierNameString);
            if (null == identifierObject) {
                throw new RuntimeException("unknown identifier object for " + identifierNameString);
            }
            currentToken = tokens.nextToken();
            if (91 == currentToken.type) {
                currentToken = tokens.nextToken();
                if (3 != currentToken.type) {
                    throw new RuntimeException("channel expected.  found " + currentToken + " instead");
                }
                int channel = Integer.parseInt(currentToken.content);
                identifierObject.setChannel(channel);
                currentToken = tokens.nextToken();
                if (93 != currentToken.type) {
                    throw new RuntimeException("']' expected.  found " + currentToken + " instead");
                }
                currentToken = tokens.nextToken();
            }
            if (46 != currentToken.type) {
                throw new RuntimeException("'.' expected.  found " + currentToken + " instead");
            }
            currentToken = tokens.nextToken();
            String fieldOrMethod = currentToken.content;
            if (!tokens.isEmpty()) {
                currentToken = tokens.nextToken();
                if (40 == currentToken.type) {
                    System.out.println("parens: " + currentToken);
                    String params = variableString.substring(currentToken.colPos + 1);
                    System.out.println("params: " + params);
                    identifierObject.setMethod(fieldOrMethod, params);
                }
            } else {
                identifierObject.setField(fieldOrMethod);
            }
            return new ASTIdentifierNode(identifierObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("ASTDeviceIdentifier elapsed2: " + elapsed);
            return new ASTVariableNode(variableString);
        }
    }

    @Override
    public Object evaluate() {
        try {
            System.out.println("evaluate _variableString: " + this._variableString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Double.NaN;
    }

    public String toString() {
        String retString = "{{ " + this._variableString + "=" + this.evaluate() + " }}";
        return retString;
    }
}

