/**
 * @license
 * Visual Blocks Editor
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Colour blocks for Blockly.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Blocks.outputs');

goog.require('Blockly.Blocks');


Blockly.Blocks.outputs.HUE = 0;

Blockly.Blocks['outputs_setblock'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Set Output Block");
    this.appendValueInput("STATE_MASK")
      .setCheck("Number")
      .setAlign(Blockly.ALIGN_RIGHT)
      .appendField("State Mask");
    this.appendValueInput("CHANNEL_MASK")
      .setCheck("Number")
      .setAlign(Blockly.ALIGN_RIGHT)
      .appendField("Channel Mask");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.Blocks.outputs.HUE);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['outputs_pulseblock'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Pulse Output Block");
    this.appendValueInput("STATE_MASK")
      .setCheck("Number")
      .setAlign(Blockly.ALIGN_RIGHT)
      .appendField("State Mask");
    this.appendValueInput("CHANNEL_MASK")
      .setCheck("Number")
      .setAlign(Blockly.ALIGN_RIGHT)
      .appendField("Channel Mask");
    this.appendValueInput("DURATION")
      .setCheck("Number")
      .setAlign(Blockly.ALIGN_RIGHT)
      .appendField("Duration");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.Blocks.outputs.HUE);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['outputs_close'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Close Output");
    this.appendValueInput("CHANNEL")
      .setCheck("Number")
    // .appendField("Channel:")
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.Blocks.outputs.HUE);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['outputs_open'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Open Output");
    this.appendValueInput("CHANNEL")
      .setCheck("Number")
    // .appendField("Channel:")
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.Blocks.outputs.HUE);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['outputs_closeall'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Close All Outputs");
    this.setInputsInline(false);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.Blocks.outputs.HUE);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['outputs_openall'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Open All Outputs");
    this.setInputsInline(false);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.Blocks.outputs.HUE);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['output_states'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Output States");
    this.setOutput(true);
    this.setColour(Blockly.Blocks.outputs.HUE);
  }
};


Blockly.Blocks['output_state'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Set Channel:");
    this.appendValueInput("CHANNEL")
      .setCheck("Number");
    this.appendDummyInput()
      .appendField("State:");
    this.appendDummyInput()
      .appendField(new Blockly.FieldDropdown([["HIGH", "HIGH"], ["LOW", "LOW"]]), "STATE");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.Blocks.outputs.HUE);
    this.setTooltip("");
    this.setHelpUrl("");
  }
};


Blockly.Blocks['output_pulse'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Pulse Output");
    this.appendValueInput("CHANNEL")
      .setCheck(null);
    this.appendDummyInput()
    // .appendField("State:");
    this.appendDummyInput()
      .appendField(new Blockly.FieldDropdown([["HIGH", "HIGH"], ["LOW", "LOW"]]), "STATE");
    this.appendDummyInput()
      .appendField("for");
    // .appendField("Duration:");
    this.appendValueInput("DURATION")
      .setCheck("Number");
    this.appendDummyInput()
      .appendField("milliseconds");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(Blockly.Blocks.outputs.HUE);
    this.setTooltip("");
    this.setHelpUrl("");
  }
};


Blockly.Blocks['output_usage_meter_value'] = {
  init: function () {
    this.appendValueInput("CHANNEL")
      .setCheck("Number")
      .appendField("Output");
    this.appendDummyInput()
      .appendField("Usage Meter Value");
    this.setOutput(true);
    this.setColour(Blockly.Blocks.outputs.HUE);
  }
};



Blockly.Blocks['external_set_10v'] = {
  init: function () {
    this.appendValueInput("CHANNEL")
      .setCheck("Number")
      .appendField("Set 10v Channel");
    this.appendValueInput("VALUE")
      .setCheck("Number")
      .appendField(new Blockly.FieldDropdown([["Scaled", "SCALED"], ["Percentage", "PERCENTAGE"], ["Raw", "RAW"]]), "TYPE")
      .appendField(" to ");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(230);
    this.setTooltip("");
    this.setHelpUrl("");
  }
};



Blockly.Blocks['external_set_420ma'] = {
  init: function () {
    this.appendValueInput("CHANNEL")
      .setCheck("Number")
      .appendField("Set 4-20ma Channel");
    this.appendValueInput("VALUE")
      .setCheck("Number")
      .appendField(new Blockly.FieldDropdown([["Scaled", "SCALED"], ["Percentage", "PERCENTAGE"], ["Raw", "RAW"]]), "TYPE")
      .appendField(" to ");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(230);
    this.setTooltip("");
    this.setHelpUrl("");
  }
};