/**
 * @license
 * Visual Blocks Editor
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Colour blocks for Blockly.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Blocks.triggers');

goog.require('Blockly.Blocks');


Blockly.Blocks.triggers.HUE = 230;


Blockly.Blocks['monitor_trigger'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Monitor")
            .appendField("     Name:")
            .appendField(new Blockly.FieldTextInput("NAME"), "NAME");
        this.appendValueInput("TRIGGER")
            .setCheck(null)
            .appendField("Trigger Condition");
        this.appendStatementInput("TRIGGER_STATEMENTS")
            .setCheck(null);
        this.setColour(Blockly.Blocks.triggers.HUE);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};



Blockly.Blocks['monitor_trigger_reset'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Monitor")
            .appendField("     Name:")
            .appendField(new Blockly.FieldTextInput("NAME"), "NAME");
        this.appendValueInput("TRIGGER")
            .setCheck(null)
            .appendField("Trigger Condition");
        this.appendStatementInput("TRIGGER_STATEMENTS")
            .setCheck(null);
        this.appendValueInput("RESET")
            .setCheck(null)
            .appendField("Reset Condition");
        this.appendStatementInput("RESET_STATEMENTS")
            .setCheck(null);
        this.setColour(Blockly.Blocks.triggers.HUE);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};



Blockly.Blocks['monitor_internalio'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("On ")
            .appendField(new Blockly.FieldDropdown([["Digital Input", "DIN"], ["Relay Output", "ROUT"]]), "TYPE");
        this.appendValueInput("CHANNEL")
            .setCheck("Number")
            .setAlign(Blockly.ALIGN_RIGHT)
        this.appendDummyInput()
            .appendField(new Blockly.FieldDropdown([["Either", "EITHER"], ["High", "HIGH"], ["Low", "LOW"]]), "STATE");
        this.appendStatementInput("STATEMENTS")
            .setCheck(null);
        this.setColour(Blockly.Blocks.triggers.HUE);
        this.setHelpUrl('help/index.html#on-input-trigger');
    }
};



Blockly.Blocks['monitor_mqtt'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Monitor MQTT Topic:")
            .appendField(new Blockly.FieldTextInput("NAME"), "NAME");
        this.appendStatementInput("TRIGGER_STATEMENTS")
            .setCheck(null);
        this.setColour(Blockly.Blocks.triggers.HUE);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};