/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.ast;

import com.integ.snap.ast.ASTBinaryNode;
import com.integ.snap.ast.ASTIdentifier;
import com.integ.snap.ast.ASTLogicalNode;
import com.integ.snap.ast.ASTNode;
import com.integ.snap.ast.ASTUnaryNode;
import com.integ.snap.ast.ASTValueNode;
import com.integ.snap.ast.ASTVariableNode;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import java.util.Stack;

public class ASTParser {
    private final String _expressionString;
    private final TokenStream _tokens;
    private Token _currentToken = null;
    private boolean _debug;
    private final Stack<Token> _operatorStack = new Stack();
    private final Queue<Token> _outputQueue = new Queue();
    private final Queue<ASTIdentifier> _identifierQueue = new Queue();
    private ASTNode _rootNode;

    public ASTParser(String expressionString) throws Exception {
        this(expressionString, false);
    }

    public ASTParser(String expressionString, boolean debug) throws Exception {
        this._expressionString = expressionString;
        this._debug = debug;
        if (this._debug || DEBUG.ON) {
            System.out.println("expressionString: " + expressionString);
        }
        Queue<Token> tokenQueue = new Queue<Token>();
        if (this._debug || DEBUG.ON) {
            System.out.println("lexer parse");
        }
        Lexer.parse(tokenQueue, expressionString);
        if (this._debug || DEBUG.ON) {
            System.out.println("create token stream");
        }
        this._tokens = new TokenStream(tokenQueue);
        this._currentToken = this._tokens.getCurrent();
        if (this._debug || DEBUG.ON) {
            System.out.println("parse(): " + this._currentToken);
        }
        this.toPostfix();
        this._rootNode = this.getTree();
    }

    public String getExpressionString() {
        return this._expressionString;
    }

    public ASTNode getRootNode() {
        return this._rootNode;
    }

    public Queue<ASTIdentifier> getUsedIdentifiers() {
        return this._identifierQueue;
    }

    private ASTNode getTree() {
        ASTNode node;
        Token token;
        Stack<ASTNode> st = new Stack<ASTNode>();
        if (this._debug || DEBUG.ON) {
            System.out.println("_outputQueue.size(): " + this._outputQueue.size());
            for (int j = 0; j < this._outputQueue.size(); ++j) {
                token = this._outputQueue.elementAt(j);
                System.out.print(token + ", ");
            }
            System.out.println("");
        }
        for (int i = 0; i < this._outputQueue.size(); ++i) {
            token = this._outputQueue.elementAt(i);
            if (this._debug || DEBUG.ON) {
                System.out.println("token[" + i + "]: " + token);
            }
            if (!this.isTokenOperator(token)) {
                ASTNode right;
                if (token.equals(0)) {
                    node = ASTVariableNode.getNode(token.content);
                    if (this._debug || DEBUG.ON) {
                        System.out.println("variable node: " + node.getClass() + " " + node);
                    }
                    st.push(node);
                    ASTIdentifier identifier = ASTIdentifier.getIdentifier(token.content);
                    this._identifierQueue.enqueue(identifier);
                } else if (token.equals(3)) {
                    double value = Double.valueOf(token.content);
                    node = this.createValueNode(value);
                    st.push(node);
                } else if (33 == token.type && null != (node = this.createUnaryNode(token, right = (ASTNode)st.pop()))) {
                    st.push(node);
                }
            } else {
                ASTNode right = (ASTNode)st.pop();
                ASTNode left = (ASTNode)st.pop();
                node = null;
                if (token.equals(43) || token.equals(45) || token.equals(42) || token.equals(47) || token.equals(37)) {
                    node = this.createBinaryNode(token, left, right);
                } else if (token.equals(10) || token.equals(9) || token.equals(94) || token.equals(11) || token.equals(12) || token.equals(62) || token.equals(13) || token.equals(60) || token.equals(14)) {
                    node = this.createLogicalNode(token, left, right);
                }
                if (null != node) {
                    st.push(node);
                }
            }
            if (!this._debug && !DEBUG.ON) continue;
            System.out.print("   working stack: ");
            for (int j = 0; j < st.size(); ++j) {
                ASTNode n = (ASTNode)st.elementAt(j);
                System.out.print(n + ", ");
            }
            System.out.println("");
        }
        node = (ASTNode)st.pop();
        return node;
    }

    private void toPostfix() {
        Token token;
        Token unaryToken = null;
        while (null != this._currentToken) {
            Token token2;
            if (this._debug || DEBUG.ON) {
                System.out.println("_currentToken: " + this._currentToken);
            }
            if (this.isCurrentToken(0)) {
                String identifierString = "";
                while (null != this._currentToken && (36 == this._currentToken.type || 0 == this._currentToken.type || 3 == this._currentToken.type || 46 == this._currentToken.type || 91 == this._currentToken.type || 93 == this._currentToken.type)) {
                    identifierString = identifierString + this._currentToken.content;
                    this.getNextToken();
                }
                token2 = new Token(0, identifierString, 0, 0);
                this._outputQueue.enqueue(token2);
                if (this._debug || DEBUG.ON) {
                    System.out.println("[" + token2.content + "] pushed to output queue");
                }
                if (null != unaryToken) {
                    this._outputQueue.enqueue(unaryToken);
                    if (this._debug || DEBUG.ON) {
                        System.out.println("[" + unaryToken.content + "] pushed to output queue");
                    }
                    unaryToken = null;
                }
            } else if (this.isCurrentToken(3)) {
                this._outputQueue.enqueue(this._currentToken);
                if (this._debug || DEBUG.ON) {
                    System.out.println("[" + this._currentToken.content + "] pushed to output queue");
                }
                this.getNextToken();
                if (null != unaryToken) {
                    this._outputQueue.enqueue(unaryToken);
                    if (this._debug || DEBUG.ON) {
                        System.out.println("[" + unaryToken.content + "] pushed to output queue");
                    }
                    unaryToken = null;
                }
            } else if (this.isTokenOperator(this._currentToken)) {
                Token peekToken;
                Token token3 = peekToken = 0 != this._operatorStack.size() ? this._operatorStack.peek() : null;
                while (null != peekToken && !peekToken.equals(40) && this.isTokenOperator(peekToken) && 0 < this.compareOperatorPrecendence(peekToken, this._currentToken)) {
                    token2 = this._operatorStack.pop();
                    this._outputQueue.enqueue(token2);
                    if (this._debug || DEBUG.ON) {
                        System.out.println("[" + token2.content + "] pushed to output queue");
                    }
                    peekToken = 0 != this._operatorStack.size() ? this._operatorStack.peek() : null;
                }
                this._operatorStack.push(this._currentToken);
                if (this._debug || DEBUG.ON) {
                    System.out.println("[" + this._currentToken.content + "] pushed to operator stack");
                }
                this.getNextToken();
            } else if (this.isCurrentToken(40)) {
                this._operatorStack.push(this._currentToken);
                if (this._debug || DEBUG.ON) {
                    System.out.println("[" + this._currentToken.content + "] pushed to operator stack");
                }
                this.getNextToken();
            } else if (this.isCurrentToken(33)) {
                unaryToken = this._currentToken;
                this.getNextToken();
            } else if (this.isCurrentToken(41)) {
                while (0 != this._operatorStack.size() && 40 != this._operatorStack.peek().type) {
                    token = this._operatorStack.pop();
                    this._outputQueue.enqueue(token);
                    if (!this._debug && !DEBUG.ON) continue;
                    System.out.println("[" + token.content + "] pushed to output queue");
                }
                if (0 != this._operatorStack.size()) {
                    this._operatorStack.pop();
                }
                this.getNextToken();
            }
            if (this._debug || DEBUG.ON) {
                this.printOperatorStack();
            }
            if (!this._debug && !DEBUG.ON) continue;
            this.printOutputQueue();
        }
        while (0 != this._operatorStack.size()) {
            token = this._operatorStack.pop();
            this._outputQueue.enqueue(token);
            if (!this._debug && !DEBUG.ON) continue;
            System.out.println("[" + token.content + "] pushed to output queue");
        }
        if (this._debug || DEBUG.ON) {
            this.printOperatorStack();
        }
        if (this._debug || DEBUG.ON) {
            this.printOutputQueue();
        }
    }

    private void printOperatorStack() {
        System.out.print("   operator stack: ");
        for (int i = 0; i < this._operatorStack.size(); ++i) {
            Token t = (Token)this._operatorStack.elementAt(i);
            System.out.print(t.content + ", ");
        }
        System.out.println("");
    }

    private void printOutputQueue() {
        System.out.print("   output queue: ");
        for (int i = 0; i < this._outputQueue.size(); ++i) {
            Token t = this._outputQueue.elementAt(i);
            System.out.print(t.content + ", ");
        }
        System.out.println("");
    }

    private ASTNode createBinaryNode(Token operator, ASTNode left, ASTNode right) {
        ASTBinaryNode node = new ASTBinaryNode(operator, left, right);
        if (this._debug || DEBUG.ON) {
            System.out.println("createBinaryNode(" + operator + ", " + left + ", " + right + ") = " + node);
        }
        return node;
    }

    private ASTNode createLogicalNode(Token operator, ASTNode left, ASTNode right) {
        ASTLogicalNode node = new ASTLogicalNode(operator, left, right);
        if (this._debug || DEBUG.ON) {
            System.out.println("createLogicalNode(" + operator + ", " + left + ", " + right + ") = " + node);
        }
        return node;
    }

    private ASTNode createUnaryNode(Token operator, ASTNode right) {
        ASTUnaryNode node = new ASTUnaryNode(operator, right);
        if (this._debug || DEBUG.ON) {
            System.out.println("createUnaryNode(" + operator + ", " + right + ") = " + node);
        }
        return node;
    }

    private ASTNode createValueNode(Number value) {
        ASTValueNode node = new ASTValueNode(value);
        if (this._debug || DEBUG.ON) {
            System.out.println("createValueNode(" + value + ") = " + node);
        }
        return node;
    }

    private void getNextToken() {
        if (this._debug || DEBUG.ON) {
            System.out.println("getNextToken.isEmpty: " + this._tokens.isEmpty());
        }
        if (this._tokens.isEmpty() || null == this._currentToken) {
            this._currentToken = null;
            return;
        }
        this._currentToken = this._tokens.nextToken();
        if (this._debug || DEBUG.ON) {
            System.out.println("token: " + this._currentToken);
        }
    }

    private boolean isCurrentToken(int tokenType) {
        return this._currentToken.type == tokenType;
    }

    private boolean isTokenOperator(Token token) {
        if (this._debug || DEBUG.ON) {
            System.out.println("token operator? " + token.content);
        }
        return 43 == token.type || 45 == token.type || 42 == token.type || 47 == token.type || 10 == token.type || 9 == token.type || 94 == token.type || 11 == token.type || 12 == token.type || 60 == token.type || 14 == token.type || 62 == token.type || 13 == token.type;
    }

    private int compareOperatorPrecendence(Token token1, Token token2) {
        int token1Precedence = this.getOperatorPrecendence(token1.type);
        int token2Precedence = this.getOperatorPrecendence(token2.type);
        if (this._debug || DEBUG.ON) {
            System.out.println("compare operators: " + token1.content + "[" + token1Precedence + "] >? " + token2.content + "[" + token2Precedence + "]");
        }
        if (token1Precedence != token2Precedence) {
            return token1Precedence - token2Precedence;
        }
        if (token1.equals(43) || token1.equals(45) || token1.equals(42) || token1.equals(47)) {
            return 1;
        }
        return 0;
    }

    private int getOperatorPrecendence(int operator) {
        switch (operator) {
            case 40: 
            case 41: {
                return 15;
            }
            case 37: 
            case 42: 
            case 47: {
                return 12;
            }
            case 43: 
            case 45: {
                return 11;
            }
            case 11: 
            case 12: {
                return 8;
            }
            case 94: {
                return 6;
            }
            case 10: {
                return 4;
            }
            case 9: {
                return 3;
            }
        }
        return 0;
    }
}

