/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.network;

import com.integ.snap.actions.Action;
import com.integ.snap.actions.Scope;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.janoslib.utils.StringUtils;
import java.io.IOException;
import java.net.Socket;
import java.util.Json;

public class TcpSendMethod
extends Action {
    private final String _host;
    private final int _port;
    private final String _data;

    public TcpSendMethod(Scope parent, Json json) {
        super(parent, json);
        this._host = StringUtils.trim(this._paramsJson.getString("IpAddress"), ' ');
        this._port = Integer.parseInt(StringUtils.trim(this._paramsJson.getString("Port"), ' '));
        this._data = StringUtils.trim(this._paramsJson.getString("Data"), ' ');
    }

    @Override
    public void execute() throws Throwable {
        System.out.println("execute Network.TcpSend: Send " + this._data + " to " + this._host + ":" + this._port);
        Socket socket = null;
        try {
            byte[] dataBytes = StringUtils.getEscapedBytes(this._data);
            System.out.println(HexUtils.hexDump(dataBytes));
            socket = new Socket(this._host, this._port);
            socket.getOutputStream().write(dataBytes);
            socket.getOutputStream().flush();
            Thread.sleep(500L);
        }
        catch (Exception ex) {
            throw new Exception("Error executing TCP Send").initCause(ex);
        }
        finally {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

