/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.externalmodules;

import com.integ.janoslib.externalmodules.DeviceInfo;
import com.integ.janoslib.externalmodules.ExternalDeviceMap;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;

public class TenVoltModule
extends DeviceInfo {
    private final int[] _rawIns = new int[4];
    private final int[] _savedRawIns = new int[4];
    private final double[] _scaledIns = new double[4];
    private final double[] _savedScaledIns = new double[4];
    private final double[] _scaledOuts = new double[4];
    private final double[] _savedScaledOuts = new double[4];

    public static TenVoltModule getModuleAtIndex(int moduleIndex) {
        DeviceInfo device = ExternalDeviceMap.getByType("TypeFD_" + moduleIndex);
        if (null != device) {
            return (TenVoltModule)device;
        }
        return null;
    }

    public TenVoltModule(long deviceAddress, int index) {
        super(deviceAddress, index);
        this._writeBlock = new byte[4];
    }

    @Override
    public void update() {
        byte[] deviceBlock = this.read();
        if (this.Updated) {
            int i;
            for (i = 0; i < 4; ++i) {
                this._rawIns[i] = ArrayUtils.getShort((byte[])deviceBlock, (int)(i * 2)) & 0xFFFF;
                this._scaledIns[i] = (double)this._rawIns[i] / 65520.0 * 20.0 - 10.0;
            }
            for (i = 0; i < 4; ++i) {
                int delta = Math.abs(this._rawIns[i] - this._savedRawIns[i]);
                if (16 >= delta) continue;
                System.out.println(String.format("10v In[%d] delta: %d", i, delta));
                this._savedRawIns[i] = this._rawIns[i];
                this._savedScaledIns[i] = this._scaledIns[i];
                System.out.println(String.format("10v In[%d] updated: " + this._precisionString, i, this._scaledIns[i]));
            }
            for (i = 0; i < 2; ++i) {
                int rawIn = ArrayUtils.getShort((byte[])deviceBlock, (int)(i * 2 + 8)) & 0xFFFF;
                this._scaledOuts[i] = (double)rawIn / 65520.0 * 10.0;
                if (-1 == this._significantDecimalPlaces) continue;
                double scale = Math.pow(10.0, this._significantDecimalPlaces);
                this._scaledOuts[i] = (double)Math.round(this._scaledOuts[i] * scale) / scale;
            }
            for (i = 0; i < 2; ++i) {
                if (this._savedScaledOuts[i] == this._scaledOuts[i]) continue;
                this._savedScaledOuts[i] = this._scaledOuts[i];
                System.out.println(String.format("10v Out[%d] updated: " + this._precisionString, i, this._scaledOuts[i]));
            }
        }
    }

    public void setScaledOutput(int channel, double value) {
        String channelBaseString = String.format("Externals/%s/Aout%d", this.DeviceAddressString, channel + 1);
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double targetDelta = value - min;
        double totalDelta = max - min;
        double percentage = targetDelta / totalDelta;
        this.setOutput(channel, (int)(percentage * 65520.0));
    }

    public void setPercentageOutput(int channel, double percentage) {
        this.setOutput(channel, (int)(65520.0 * (percentage /= 100.0)));
    }

    public void setOutput(int channel, int value) {
        System.out.println("set output for channel " + channel + " to " + value);
        ArrayUtils.setShort((byte[])this._writeBlock, (int)(channel * 2), (short)((short)value));
    }
}

