/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.controlstructures;

import com.integ.snap.actions.Action;
import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.BooleanResultAction;
import com.integ.snap.actions.Scope;
import com.integ.snap.actions.logical.LogicalFactory;
import java.util.ArrayList;
import java.util.Json;

public class IfBlock
extends Action {
    private ArrayList<BooleanResultAction> _ifConditionalList = new ArrayList();
    private final ArrayList<Action[]> _ifActionsList = new ArrayList();
    private Action[] _elseActions;

    public IfBlock(Scope parent, Json json) {
        super(parent, json);
        int n = 0;
        while (null != this._paramsJson.get("IfConditional" + n)) {
            System.out.println("IfConditional" + n);
            Json conditionalJson = (Json)this._paramsJson.get("IfConditional" + n);
            System.out.println("conditionalJson: " + conditionalJson);
            try {
                BooleanResultAction conditional = LogicalFactory.getLogicalMethod(parent, conditionalJson);
                this._ifConditionalList.add(conditional);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Json[] actions = (Json[])this._paramsJson.get("IfActions" + n);
            System.out.println(actions.length + " if actions");
            Action[] ifActions = new Action[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                Json actionJson = actions[i];
                try {
                    ifActions[i] = ActionFactory.getActionClass(parent, actionJson);
                    System.out.println("ifActions[" + i + "]: " + ifActions[i]);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this._ifActionsList.add(ifActions);
            ++n;
        }
        Json[] actions = (Json[])this._paramsJson.get("ElseActions");
        if (null != actions) {
            System.out.println(actions.length + " else actions");
            this._elseActions = new Action[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                Json actionJson = actions[i];
                try {
                    this._elseActions[i] = ActionFactory.getActionClass(parent, actionJson);
                    System.out.println("_elseActions[i]: " + this._elseActions[i]);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void execute() throws Throwable {
        try {
            boolean ifBlockExecuted = false;
            for (int i = 0; !ifBlockExecuted && i < this._ifConditionalList.size(); ++i) {
                Action[] ifActions;
                BooleanResultAction conditional = this._ifConditionalList.get(i);
                boolean result = conditional.getResult();
                if (!result) continue;
                ifBlockExecuted = true;
                for (Action action : ifActions = this._ifActionsList.get(i)) {
                    action.execute();
                }
            }
            if (ifBlockExecuted) {
                for (Action action : this._elseActions) {
                    action.execute();
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new Exception("error executing if block").initCause(ex);
        }
    }
}

