/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.ast;

import com.integ.snap.ast.ASTNode;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.lexer.Token;

public class ASTBinaryNode
implements ASTNode {
    private final Token _operator;
    private final ASTNode _left;
    private final ASTNode _right;

    public ASTBinaryNode(Token operator, ASTNode left, ASTNode right) {
        this._operator = operator;
        this._left = left;
        this._right = right;
    }

    @Override
    public Number evaluate() {
        Double result = Double.NaN;
        try {
            Object left = this._left.evaluate();
            if (DEBUG.ON) {
                System.out.println("binary node left: " + left + " " + left.getClass());
            }
            Object right = this._right.evaluate();
            if (DEBUG.ON) {
                System.out.println("binary node right: " + right + " " + right.getClass());
            }
            if (!(left instanceof Number) || !(right instanceof Number)) {
                return 0;
            }
            switch (this._operator.type) {
                case 43: {
                    if (left instanceof Integer && right instanceof Integer) {
                        return (Integer)left + (Integer)right;
                    }
                    double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                    double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                    result = l + r;
                    break;
                }
                case 45: {
                    if (left instanceof Integer && right instanceof Integer) {
                        return (Integer)left - (Integer)right;
                    }
                    double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                    double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                    result = l - r;
                    break;
                }
                case 42: {
                    if (left instanceof Integer && right instanceof Integer) {
                        return (Integer)left * (Integer)right;
                    }
                    double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                    double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                    result = l * r;
                    break;
                }
                case 47: {
                    double l = left instanceof Integer ? (double)((Integer)left).intValue() : (Double)left;
                    double r = right instanceof Integer ? (double)((Integer)right).intValue() : (Double)right;
                    result = l / r;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Left: " + this._left);
            System.out.println("Right: " + this._right);
        }
        if (DEBUG.ON) {
            System.out.println("ASTUnaryNode: " + this + " = " + result);
        }
        return result;
    }

    public String toString() {
        String retString = "(";
        retString = retString + this._left;
        retString = retString + " " + this._operator.content + " ";
        retString = retString + this._right;
        retString = retString + ")";
        return retString;
    }
}

