/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generating Json for colour blocks.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Json.other');

goog.require('Blockly.Json');


Blockly.Json['comment'] = function (block) {
  return '';
  // var text_comment = block.getFieldValue('COMMENT');
  // var codeJson = {};
  // var code = JSON.stringify(codeJson, null, 2);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  // return code;
};


Blockly.Json['other_reboot'] = function (block) {
  var codeJson = { Type: 'Other', Method: 'Reboot', Params: {} };
  var code = JSON.stringify(codeJson);
  return code;
};


Blockly.Json['other_execute_commandline'] = function (block) {
  var command = Blockly.Json.statementToCode(block, 'COMMAND');

  var codeJson = { Type: 'Other', Method: 'ExecuteCommandLine', Params: { Command: command } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};