/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generating JSON for colour blocks.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Json.ethernet');

goog.require('Blockly.Json');



Blockly.Json['ethernet_tcp_send'] = function (block) {
  var value_ip_address = Blockly.Json.statementToCode(block, 'IP_ADDRESS').trim();
  var value_port = Blockly.Json.valueToCode(block, 'PORT');
  var value_data = Blockly.Json.statementToCode(block, 'DATA').trim();

  var codeJson = {
    Type: "Network", Method: "TcpSend", Params: {
      IpAddress: value_ip_address, Port: value_port, Data: value_data
    }
  };
  var code = JSON.stringify(codeJson, null, 2);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};



Blockly.Json['ethernet_udp_send'] = function (block) {
  var value_ip_address = Blockly.Json.statementToCode(block, 'IP_ADDRESS').trim();
  var value_port = Blockly.Json.valueToCode(block, 'PORT');
  var value_data = Blockly.Json.statementToCode(block, 'DATA').trim();

  var codeJson = {
    Type: "Network", Method: "UdpSend", Params: {
      IpAddress: value_ip_address, Port: value_port, Data: value_data
    }
  };
  var code = JSON.stringify(codeJson, null, 2);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};



Blockly.Json['communication_send_email'] = function (block) {
  var to_addresses = Blockly.Json.statementToCode(block, 'TO_ADDRESSES');
  var subject = Blockly.Json.statementToCode(block, 'SUBJECT');
  var message = Blockly.Json.statementToCode(block, 'MESSAGE');

  var codeJson = {
    Type: "Network", Method: "EmailSend", Params: {
      ToAddresses: to_addresses, Subject: subject, Message: message
    }
  };
  var code = JSON.stringify(codeJson, null, 2);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};



Blockly.Json['communication_send_email_profile'] = function (block) {
  var email_profile = Blockly.Json.statementToCode(block, 'EMAIL_PROFILE');

  var codeJson = {
    Type: "Network", Method: "EmailProfileSend", Params: {
      EmailProfile: email_profile
    }
  };
  var code = JSON.stringify(codeJson, null, 2);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};