/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generating Json for loop blocks.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Json.loops');

goog.require('Blockly.Json');


// Blockly.Json['controls_repeat_ext'] = function (block) {
//   var repeats = Blockly.Json.valueToCode(block, 'TIMES', Blockly.Json.ORDER_ASSIGNMENT) || '0';
//   var branch = Blockly.Json.statementToCode(block, 'DO');
//   var branchJson = '';
//   if ('' !== branch) branchJson = JSON.parse('[' + branch + ']');

//   var codeJson = { Type: 'Control', Method: 'Repeat', Params: { Count: repeats, Actions: branchJson } };
//   var code = JSON.stringify(codeJson);
//   if (block.nextConnection.targetConnection != null) code += ',\n';
//   return code;
// };



// Blockly.Json['controls_flow_statements'] = function (block) {
//   // Flow statements: continue, break.
//   switch (block.getFieldValue('FLOW')) {
//     case 'BREAK':
//       return 'break;\n';
//     case 'CONTINUE':
//       return 'continue;\n';
//   }
//   throw 'Unknown flow statement.';
// };



Blockly.Json['for_loop'] = function (block) {
  var variable = Blockly.Json.valueToCode(block, 'VARIABLE', Blockly.Json.ORDER_ATOMIC);
  variable = variable.replaceAll('"', '');

  var start = Blockly.Json.valueToCode(block, 'START', Blockly.Json.ORDER_ATOMIC);
  var end = Blockly.Json.valueToCode(block, 'END', Blockly.Json.ORDER_ATOMIC);
  var branch = Blockly.Json.statementToCode(block, 'STATEMENTS');
  var actionsJson = '';
  if ('' !== branch) actionsJson = JSON.parse('[' + branch + ']');

  var codeJson = {
    Type: 'Control', Method: 'ForLoop', Params: {
      Variable: variable, Start: start, End: end, Actions: actionsJson
    }
  };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};



Blockly.Json['loops_every'] = function (block) {
  var name = block.getFieldValue('NAME')

  var seconds = Blockly.Json.valueToCode(block, 'SECONDS', Blockly.Json.ORDER_ATOMIC);
  var branch = Blockly.Json.statementToCode(block, 'STATEMENTS');
  var actionsJson = '';
  if ('' !== branch) actionsJson = JSON.parse('[' + branch + ']');

  var codeJson = {
    Type: 'Trigger', Method: 'Every', Params: {
      Name: name,
      Seconds: seconds, Actions: actionsJson
    }
  };
  var code = JSON.stringify(codeJson);
  return code;
};



Blockly.Json['while'] = function (block) {
  var expression = Blockly.Json.valueToCode(block, 'EXPRESSION', Blockly.Json.ORDER_ATOMIC);
  if ('' !== expression) expression = JSON.parse(expression);
  else expression = {};

  var branch = Blockly.Json.statementToCode(block, 'STATEMENTS');
  var actionsJson = '';
  if ('' !== branch) actionsJson = JSON.parse('[' + branch + ']');

  var codeJson = {
    Type: 'Control', Method: 'While', Params: {
      Expression: expression, Actions: actionsJson
    }
  };
  var code = JSON.stringify(codeJson);
  return code;
};
