/*
 * Decompiled with CFR 0.152.
 */
package com.integ.taskerjson;

import com.integ.taskerjson.Config;
import com.integ.taskerjson.SnapAsciiCommandClient;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.net.TcpServer;
import com.integpg.janoslib.net.TcpServerEvent;
import com.integpg.janoslib.net.TcpServerListener;
import com.integpg.janoslib.text.QuickDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class SnapAsciiCommandServer
implements TcpServerListener {
    private static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat();
    private final TcpServer _asciiServer = new TcpServer("snap-ascii-server", Config.getAsciiCommandServerPort());

    public SnapAsciiCommandServer() {
        this._asciiServer.setTcpServerListener(this);
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        System.out.println(String.format("client connected at %s", QUICK_DATE_FORMAT.format()));
        InputStream inputStream = null;
        try {
            Socket socket = evt.getSocket();
            String socketInfo = socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
            System.out.println(String.format("%s connected at %s", socketInfo, QUICK_DATE_FORMAT.format()));
            inputStream = socket.getInputStream();
            SnapAsciiCommandClient asciiCommandClient = new SnapAsciiCommandClient(socketInfo, inputStream);
            asciiCommandClient.start();
        }
        catch (IOException ex) {
            AppLog.error(ex);
        }
    }

    public void start() {
        AppLog.info("start snap ascii tcp server");
        this._asciiServer.start();
    }
}

