/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions.controlstructures;

import com.integ.snap.actions.Action;
import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.Scope;
import java.util.Json;

public class ForLoop
extends Action {
    private final String _variable;
    private final Action[] _actions;

    public ForLoop(Scope parent, Json json) {
        super(parent, json);
        this._variable = this._paramsJson.getString("Variable");
        Json[] actions = (Json[])this._paramsJson.get("Actions");
        this._actions = new Action[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            Json actionJson = actions[i];
            try {
                this._actions[i] = ActionFactory.getActionClass(parent, actionJson);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void execute() throws Throwable {
        try {
            boolean ascending;
            int from = this.getIntParam("Start");
            int to = this.getIntParam("End");
            boolean bl = ascending = to > from;
            if (ascending) {
                for (int i = from; i <= to; ++i) {
                    this._parent.setVariable(this._variable, i);
                    for (Action action : this._actions) {
                        action.execute();
                    }
                }
            } else {
                for (int i = from; i >= to; --i) {
                    this._parent.setVariable(this._variable, i);
                    for (Action action : this._actions) {
                        action.execute();
                    }
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new Exception("error executing for loop").initCause(ex);
        }
    }
}

