/**
 * @license
 * Visual Blocks Editor
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Colour blocks for Blockly.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Blocks.other');

goog.require('Blockly.Blocks');


Blockly.Blocks.other.HUE = 90;

Blockly.Blocks['comment'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("//")
      .appendField(new Blockly.FieldTextInput("comment here"), "COMMENT");
    this.setInputsInline(true);
    this.setPreviousStatement(true);
    this.setNextStatement(true);
    this.setColour(Blockly.Blocks.other.HUE);
    this.setTooltip('');
    this.setHelpUrl('http://www.example.com/');
  }
};


Blockly.Blocks['other_reboot'] = {
  init: function () {
    this.appendDummyInput()
      .appendField("Reboot");
    this.setPreviousStatement(true, null);
    this.setColour(Blockly.Blocks.other.HUE);
    this.setTooltip("This will reboot the unit.  It must be the last item in the function.");
    this.setHelpUrl("");
  }
};


Blockly.Blocks['other_execute_commandline'] = {
  init: function () {
    this.appendValueInput("COMMAND")
      .setCheck("String")
      .appendField("Execute Command: ");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(315);
    this.setTooltip("");
    this.setHelpUrl("");
  }
};