/*
 * Decompiled with CFR 0.152.
 */
package com.integ.taskerjson;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.janoslib.messagepump.MessagePumpListener;
import com.integ.snap.actions.Action;
import com.integ.taskerjson.MqttInterfaceListener;
import com.integ.taskerjson.MqttPublishSystemMessage;
import com.integ.taskerjson.MqttSubscribeSystemMessage;
import com.integ.taskerjson.MqttSystemMessage;
import com.integ.taskerjson.SnapsCollection;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.JsonUtils;
import com.integpg.system.JANOS;
import com.integpg.system.SystemMsg;
import java.util.Json;

public class MqttInterface
implements MessagePumpListener {
    private boolean _connected = false;
    private SystemMsg _systemMsg;
    private Json _receivedJson;
    private String _messageString;
    private MqttInterfaceListener _interfaceListener;

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (1600 == systemMsg.type) {
            this._systemMsg = systemMsg;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long start = System.currentTimeMillis();
                    MqttInterface.this.processMessage();
                    long elapsed = System.currentTimeMillis() - start;
                    MessagePumpEngine.LOG.info("      " + MqttInterface.this._messageString + " processed in " + elapsed);
                }
            }).start();
        }
    }

    private void processMessage() {
        String contentJsonString = new String(this._systemMsg.msg);
        this._receivedJson = new Json(contentJsonString);
        this._messageString = this._receivedJson.getString("Message");
        System.out.println("_messageString: " + this._messageString);
        if ("current-status".equalsIgnoreCase(this._messageString)) {
            this._connected = JsonUtils.getBoolean(this._receivedJson.get("ConnectionStatus"), false);
            System.out.println("_connected: " + this._connected);
            String connectionInfo = this._receivedJson.getString("ConnectionInfo");
            System.out.println("connectionInfo: " + connectionInfo);
        } else if ("unhandled-topic".equalsIgnoreCase(this._messageString)) {
            String topicString = null;
            String payloadString = null;
            try {
                topicString = this._receivedJson.getString("Topic");
                if (null == topicString || "".equals(topicString)) {
                    throw new IllegalArgumentException("MQTT Topic must not be null in MQTT Message");
                }
                payloadString = this._receivedJson.getString("Payload");
                if (null == payloadString || "".equals(payloadString)) {
                    throw new IllegalArgumentException("MQTT Payload must not be null in MQTT Message");
                }
                System.out.println(String.format("topic: %s, payload: %s", topicString, payloadString));
                Action action = SnapsCollection.getActionFor("mqtt");
                action.execute();
            }
            catch (Throwable ex) {
                AppLog.error("error processing MQTT subscription handler");
            }
        }
    }

    public void getStatus() {
        MqttSystemMessage msg = new MqttSystemMessage("get-status");
        MessagePumpEngine.postMessage(msg.getSystemMsg());
    }

    public void publish(String topic, byte[] payload) {
        MqttPublishSystemMessage msg = new MqttPublishSystemMessage("jnior/" + JANOS.getSerialNumber() + "/status/taskerjson", payload);
        MessagePumpEngine.postMessage(msg.getSystemMsg());
    }

    public void subscribe(String topic) {
        MqttSubscribeSystemMessage msg = new MqttSubscribeSystemMessage(new String[]{"jnior/" + JANOS.getSerialNumber() + "/execute/scriptname"});
        MessagePumpEngine.postMessage(msg.getSystemMsg());
    }
}

