/*
 * Decompiled with CFR 0.152.
 */
package com.integ.taskerjson;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.snap.actions.Action;
import com.integ.taskerjson.StackFile;
import com.integ.taskerjson.messagehandlers.ErrorMessage;
import com.integ.taskerjson.messagehandlers.StackNamesMessage;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.threading.ThreadPool;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class SnapsCollection {
    private final File _directory;
    private static final Hashtable<String, Action> SnapCollection = new Hashtable();

    public SnapsCollection(File directory) {
        this._directory = directory;
    }

    static void put(String name, Action action) {
        System.out.println("snapcollection put: " + name);
        SnapCollection.put(name, action);
    }

    static int size() {
        return SnapCollection.size();
    }

    public void loadFiles() {
        try {
            String[] filenames = this._directory.list();
            System.out.println("filenames length: " + filenames.length);
            for (String filename : filenames) {
                System.out.println("filename: " + filename);
            }
            for (String filename : filenames) {
                File file = new File(this._directory.getPath() + "/" + filename);
                SnapsCollection.loadFile(file);
            }
        }
        catch (Exception ex) {
            AppLog.error("error loading files", ex);
        }
        try {
            String[] stackNames = SnapsCollection.getStacks();
            StackNamesMessage stackNamesMessage = new StackNamesMessage(stackNames);
            MessagePumpEngine.postMessage(stackNamesMessage.build());
        }
        catch (Throwable ex) {
            AppLog.error("error sending stack names", ex);
        }
    }

    public static Action getActionFor(String functionName) {
        Action action = SnapCollection.get(functionName);
        return action;
    }

    public static String[] getStacks() {
        ArrayList<String> stackNames = new ArrayList<String>();
        Enumeration<String> e = SnapCollection.keys();
        while (e.hasMoreElements()) {
            stackNames.add(e.nextElement());
        }
        return (String[])stackNames.toArray();
    }

    public static void loadFile(File file) {
        try {
            AppLog.info("load " + file.getPath());
            StackFile snapFile = new StackFile(file);
            snapFile.load();
            AppLog.info(file.getPath() + " loaded");
        }
        catch (Exception ex) {
            AppLog.error("error loading " + file, ex);
        }
    }

    public static void executeByName(final String functionNameString, final String requester) {
        ThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Action action = SnapsCollection.getActionFor(functionNameString);
                    if (null == action) {
                        throw new RuntimeException(functionNameString + " not found");
                    }
                    AppLog.info("execute " + functionNameString + " requested by " + requester);
                    action.execute();
                }
                catch (Throwable ex) {
                    Throwable throwable = new Exception("error processing execute script handler").initCause(ex);
                    AppLog.error(throwable);
                    ErrorMessage errorMessage = new ErrorMessage(throwable);
                    MessagePumpEngine.postMessage(errorMessage.build());
                }
            }
        });
    }
}

