/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.ast;

import com.integ.janoslib.externalmodules.EnvironSensor;
import com.integ.janoslib.externalmodules.ExternalDeviceMap;
import com.integ.janoslib.externalmodules.TempProbe;
import com.integ.snap.ast.ASTDeviceIdentifier;
import com.integ.snap.ast.ASTVariableNode;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.JANOS;

public class DeviceNode
extends ASTVariableNode {
    private final ASTDeviceIdentifier _deviceIdentifier;

    protected DeviceNode(String variableString) {
        super(variableString);
        this._deviceIdentifier = new ASTDeviceIdentifier(variableString);
    }

    @Override
    public Number evaluate() {
        String deviceString = this._deviceIdentifier.getDeviceString();
        int channel = this._deviceIdentifier.getChannel();
        String fieldName = this._deviceIdentifier.getFieldName();
        if (deviceString.equalsIgnoreCase("rout")) {
            if ("state".equalsIgnoreCase(fieldName)) {
                return JANOS.getOutputStates() >> channel - 1 & 1;
            }
            if ("usagemeter".equalsIgnoreCase(fieldName)) {
                return JANOS.getUsageMeter((int)(channel - 1 + UnitConfig.getInputCount()));
            }
        } else if (deviceString.equalsIgnoreCase("din")) {
            if ("state".equalsIgnoreCase(fieldName)) {
                return JANOS.getInputStates() >> channel - 1 & 1;
            }
            if ("counter".equalsIgnoreCase(fieldName)) {
                return JANOS.getInputCounter((int)(channel - 1));
            }
            if ("usagemeter".equalsIgnoreCase(fieldName)) {
                return JANOS.getUsageMeter((int)(channel - 1));
            }
        } else if (deviceString.equalsIgnoreCase("temp")) {
            TempProbe tempProbe = (TempProbe)ExternalDeviceMap.getByType("Type28_" + channel);
            System.out.println("tempProbe: " + tempProbe);
            if (null != tempProbe) {
                tempProbe.update();
                if ("c".equalsIgnoreCase(fieldName) || "celsius".equalsIgnoreCase(fieldName)) {
                    return tempProbe.Celsius;
                }
                if ("f".equalsIgnoreCase(fieldName) || "fahrenheit".equalsIgnoreCase(fieldName)) {
                    return tempProbe.getFahrenheit(tempProbe.Celsius);
                }
            }
        } else if (deviceString.equalsIgnoreCase("env")) {
            EnvironSensor environSensor = (EnvironSensor)ExternalDeviceMap.getByType("Type7E_" + channel);
            System.out.println("environSensor: " + environSensor);
            if (null != environSensor) {
                environSensor.update();
                if ("c".equalsIgnoreCase(fieldName) || "celsius".equalsIgnoreCase(fieldName)) {
                    return environSensor.Celsius;
                }
                if ("f".equalsIgnoreCase(fieldName) || "fahrenheit".equalsIgnoreCase(fieldName)) {
                    return environSensor.getFahrenheit(environSensor.Celsius);
                }
                if ("h".equalsIgnoreCase(fieldName) || "humidity".equalsIgnoreCase(fieldName)) {
                    return environSensor.Humidity;
                }
            }
        } else if (!deviceString.equalsIgnoreCase("date") || "format".equalsIgnoreCase(fieldName)) {
            // empty if block
        }
        throw new RuntimeException(fieldName + " not a member of " + deviceString);
    }

    static {
        ExternalDeviceMap.start();
    }
}

