/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions;

import com.integ.snap.actions.Action;
import com.integ.snap.actions.Scope;
import com.integ.snap.actions.assignment.AssignmentFactory;
import com.integ.snap.actions.controlstructures.ControlStructureFactory;
import com.integ.snap.actions.externalcontrol.ExternalControlFactory;
import com.integ.snap.actions.filesystem.FileSystemFactory;
import com.integ.snap.actions.logical.LogicalFactory;
import com.integ.snap.actions.network.NetworkFactory;
import com.integ.snap.actions.other.OtherFactory;
import com.integ.snap.actions.relaycontrol.RelayControlFactory;
import com.integ.snap.actions.timing.TimingFactory;
import com.integ.snap.triggers.TriggerFactory;
import com.integpg.janoslib.utils.JsonUtils;
import java.util.Json;

public class ActionFactory {
    public static Action getActionClass(Scope parent, Json json) throws Exception {
        if (json.isEmpty()) {
            return null;
        }
        boolean disabled = JsonUtils.getBoolean(json.get("Disabled"), false);
        if (disabled) {
            return null;
        }
        System.out.println("getActionClass json: " + json.toString());
        String typeString = json.getString("Type");
        Action action = null;
        switch (typeString) {
            case "Assignment": {
                action = AssignmentFactory.getAssignmentMethod(parent, json);
                break;
            }
            case "Control": {
                action = ControlStructureFactory.getControlStructureMethod(parent, json);
                break;
            }
            case "Logical": {
                action = LogicalFactory.getLogicalMethod(parent, json);
                break;
            }
            case "RelayControl": {
                action = RelayControlFactory.getRelayControlMethod(parent, json);
                break;
            }
            case "ExternalControl": {
                action = ExternalControlFactory.getMethod(parent, json);
                break;
            }
            case "Timing": {
                action = TimingFactory.getTimingMethod(parent, json);
                break;
            }
            case "Trigger": {
                action = TriggerFactory.getTriggerMethod(parent, json);
                break;
            }
            case "Network": {
                action = NetworkFactory.getActionMethod(parent, json);
                break;
            }
            case "FileSystem": {
                action = FileSystemFactory.getActionMethod(parent, json);
                break;
            }
            case "Other": {
                action = OtherFactory.getOtherMethod(parent, json);
                break;
            }
            default: {
                throw new Exception(String.format("Unknown Type: %s in %s", typeString, json.toString()));
            }
        }
        return action;
    }
}

