/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generating Json for colour blocks.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Json.outputs');

goog.require('Blockly.Json');


Blockly.Json['monitor_trigger'] = function (block) {
	var name = block.getFieldValue('NAME');

	var trigger_condition = Blockly.Json.valueToCode(block, 'TRIGGER', Blockly.Json.ORDER_ATOMIC);
	if ('' !== trigger_condition) trigger_condition = JSON.parse(trigger_condition);
	else trigger_condition = {};

	var trigger_statements = [Blockly.Json.statementToCode(block, 'TRIGGER_STATEMENTS')];
	if ('' !== trigger_statements) trigger_statements = JSON.parse('[' + trigger_statements + ']');
	else trigger_statements = [];

	var codeJson = {
		Type: 'Trigger', Method: 'MonitorTrigger', Params: {
			Name: name, Disabled: block.disabled,
			TriggerCondition: trigger_condition, TriggerActions: trigger_statements
		}
	};
	var code = JSON.stringify(codeJson);
	return code;
};


Blockly.Json['monitor_trigger_reset'] = function (block) {
	var name = block.getFieldValue('NAME');

	var trigger_condition = Blockly.Json.valueToCode(block, 'TRIGGER', Blockly.Json.ORDER_ATOMIC);
	if ('' !== trigger_condition) trigger_condition = JSON.parse(trigger_condition);
	else trigger_condition = {};

	var trigger_statements = [Blockly.Json.statementToCode(block, 'TRIGGER_STATEMENTS')];
	if ('' !== trigger_statements) trigger_statements = JSON.parse('[' + trigger_statements + ']');
	else trigger_statements = [];

	var reset_condition = Blockly.Json.valueToCode(block, 'RESET', Blockly.Json.ORDER_ATOMIC);
	if ('' !== reset_condition) reset_condition = JSON.parse(reset_condition);
	else reset_condition = {};

	var reset_statements = [Blockly.Json.statementToCode(block, 'RESET_STATEMENTS')];
	if ('' !== reset_statements) reset_statements = JSON.parse('[' + reset_statements + ']');
	else reset_statements = [];

	var codeJson = {
		Type: 'Trigger', Method: 'MonitorTrigger', Params: {
			Name: name, Disabled: block.disabled,
			TriggerCondition: trigger_condition, TriggerActions: trigger_statements,
			ResetCondition: reset_condition, ResetActions: reset_statements
		}
	};
	var code = JSON.stringify(codeJson);
	return code;
};




Blockly.Json['inputs_onchange'] = function (block) {
	var value_channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);
	var dropdown_state = block.getFieldValue('STATE');
	var branch = Blockly.Json.statementToCode(block, 'STATEMENTS');
	var code = '{"Disabled":' + block.disabled + ',"Category":"inputs","Command":"onchange","Channel":' + value_channel + ',"State":"' + dropdown_state + '", "Statements":[ ' + branch + ' ]}';
	return code;
};


Blockly.Json['inputs_monitor'] = function (block) {
	var device = Blockly.Json.valueToCode(block, 'DEVICE', Blockly.Json.ORDER_ATOMIC);
	var trigger_value = block.getFieldValue('TRIGGER_SET_POINT');
	var statements_trigger = [Blockly.Json.statementToCode(block, 'TRIGGER')];
	var reset_value = block.getFieldValue('RESET_SET_POINT');
	var statements_reset = [Blockly.Json.statementToCode(block, 'RESET')];

	var codeJson = { Type: 'Trigger', Method: 'Monitor', Params: { Device: device, TriggerValue: trigger_value, TriggerActions: statements_trigger, ResetValue: reset_value, ResetActions: statements_reset } };
	var code = JSON.stringify(codeJson);
	return code;
};


Blockly.Json['temperature_value'] = function (block) {
	var dropdown_units = block.getFieldValue('UNITS');
	var value_channel = Blockly.Json.valueToCode(block, 'CHANNEL', Blockly.Json.ORDER_ATOMIC);

	var codeJson = { Device: 'Type28', Params: { Channel: value_channel, Units: dropdown_units } };
	var code = JSON.stringify(codeJson);
	return code;
};