/**
 * @license
 * Visual Blocks Language
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generating Json for text blocks.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Json.texts');

goog.require('Blockly.Json');


Blockly.Json['text'] = function (block) {
  // value output
  var text = block.getFieldValue('TEXT');
  return text;
  // var codeJson = { Type: 'Text', Method: 'Text', Params: { Text: text } };
  // var code = JSON.stringify(codeJson);
  // return [code, Blockly.Json.ORDER_ATOMIC];
};


Blockly.Json['text_print2'] = function (block) {
  // value output
  var text_value = Blockly.Json.valueToCode(block, 'TEXT') || "";
  var code = '{"Id":' + block.id + ',"Category":"text","Command":"print","Value":' + text_value + '}';
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};



Blockly.Json['text_log'] = function (block) {
  var filename = block.getFieldValue('FILENAME');

  // Create a list with any number of elements of any type.
  var parameters = "";
  for (var n = 0; n < block.itemCount_; n++) {
    if (n > 0) parameters += ", ";
    parameters += Blockly.Json.valueToCode(block, 'ADD' + n,
      Blockly.Json.ORDER_COMMA) || '';
  }

  var codeJson = { Type: 'FileSystem', Method: 'Log', Params: { Filename: filename, Output: parameters } };
  var code = JSON.stringify(codeJson);
  // if (block.nextConnection.targetConnection != null) code += ',\n';
  return code;
};