/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.actions;

import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.Scope;
import com.integpg.janoslib.utils.JsonUtils;
import java.util.Json;

public abstract class Action {
    protected final Scope _parent;
    protected final Json _json;
    protected final Json _paramsJson;
    protected String _methodString;
    protected final String _name;
    protected final boolean _disabled;
    protected final String _guid;

    protected Action(Scope parent, Json json) {
        this._parent = parent;
        this._json = json;
        this._paramsJson = (Json)json.get("Params");
        System.out.println("_paramsJson: " + this._paramsJson);
        this._name = this._paramsJson.getString("Name");
        this._disabled = JsonUtils.getBoolean(this._json.get("Disabled"), false);
        this._guid = this._json.getString("Guid");
    }

    public String getName() {
        return this._name;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public String getGuid() {
        return this._guid;
    }

    public abstract void execute() throws Throwable;

    public Action[] getActions(String actionsName) {
        Action[] actions;
        if (null != this._paramsJson.get(actionsName)) {
            Json[] actionsJson = (Json[])this._paramsJson.get(actionsName);
            actions = new Action[actionsJson.length];
            for (int i = 0; i < actions.length; ++i) {
                Json actionJson = actionsJson[i];
                try {
                    actions[i] = ActionFactory.getActionClass(this._parent, actionJson);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            actions = new Action[]{};
        }
        return actions;
    }

    protected int getIntParam(String name) {
        String variableName;
        Object value = this._paramsJson.get(name);
        if (value instanceof String && (variableName = (String)value).startsWith("$")) {
            value = this._parent.getVariable(variableName);
        }
        return Integer.parseInt(value.toString());
    }

    protected double getDoubleParam(String name) {
        Object value;
        double result = Double.MIN_VALUE;
        if (this._paramsJson.containsKey(name) && null != (value = this._paramsJson.get(name))) {
            String variableName;
            if (value instanceof String && (variableName = (String)value).startsWith("$")) {
                value = this._parent.getVariable(variableName);
            }
            result = Double.valueOf(value.toString());
        }
        return result;
    }

    protected String getStringParam(String name) {
        Object value = this._paramsJson.get(name);
        return String.valueOf(value);
    }
}

