/**
 * @license
 * Visual Blocks Editor
 *
 * Copyright 2012 Google Inc.
 * https://developers.google.com/blockly/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Colour blocks for Blockly.
 * @author fraser@google.com (Neil Fraser)
 */
'use strict';

goog.provide('Blockly.Blocks.timing');

goog.require('Blockly.Blocks');


Blockly.Blocks.timing.HUE = 300;

Blockly.Blocks['timing_delay'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Delay");
        this.appendValueInput("DURATION")
            .setCheck("Number")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Duration");
        this.appendDummyInput()
            .appendField(" milliseconds");
        this.setInputsInline(true);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(Blockly.Blocks.timing.HUE);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};


Blockly.Blocks['timing_delay_seconds'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Delay");
        this.appendValueInput("DURATION")
            .setCheck("Number")
            .setAlign(Blockly.ALIGN_RIGHT)
            .appendField("Duration");
        this.appendDummyInput()
            .appendField(" seconds");
        this.setInputsInline(true);
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(Blockly.Blocks.timing.HUE);
        this.setTooltip('');
        this.setHelpUrl('http://www.example.com/');
    }
};


Blockly.Blocks['schedule_day_of_week'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Current Day is");
        this.appendDummyInput()
            .appendField("SUN")
            .appendField(new Blockly.FieldCheckbox("TRUE"), "SUNDAY")
            .appendField("MON")
            .appendField(new Blockly.FieldCheckbox("TRUE"), "MONDAY")
            .appendField("TUE")
            .appendField(new Blockly.FieldCheckbox("TRUE"), "TUESDAY")
            .appendField("WED")
            .appendField(new Blockly.FieldCheckbox("TRUE"), "WEDNESDAY")
            .appendField("THU")
            .appendField(new Blockly.FieldCheckbox("TRUE"), "THURSDAY")
            .appendField("FRI")
            .appendField(new Blockly.FieldCheckbox("TRUE"), "FRIDAY")
            .appendField("SAT")
            .appendField(new Blockly.FieldCheckbox("TRUE"), "SATURDAY");
        this.setInputsInline(true);
        this.setOutput(true);
        this.setColour(Blockly.Blocks.timing.HUE);
    }
};



Blockly.Blocks['clock_is_day_of_week'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Current Day is")
            .appendField(new Blockly.FieldDropdown([["Sunday", "SUNDAY"], ["Monday", "MONDAY"], ["Tuesday", "TUESDAY"], ["Wednesday", "WEDNESDAY"], ["Thursday", "THURSDAY"], ["Friday", "FRIDAY"], ["Saturday", "SATURDAY"]]), "DAY_OF_WEEK");
        this.setOutput(true);
        this.setColour(Blockly.Blocks.timing.HUE);
    }
};



Blockly.Blocks['clock_time_range'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("From");
        this.appendDummyInput()
            .appendField(new Blockly.FieldTextInput("00"), "FROM_HOUR")
            .appendField(":")
            .appendField(new Blockly.FieldTextInput("00"), "FROM_MINUTE");
        this.appendDummyInput()
            .appendField("To");
        this.appendDummyInput()
            .appendField(new Blockly.FieldTextInput("00"), "TO_HOUR")
            .appendField(":")
            .appendField(new Blockly.FieldTextInput("00"), "TO_MINUTE");
        this.setInputsInline(true);
        this.setOutput(true);
        this.setColour(230);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};



Blockly.Blocks['schedule_at'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("At");
        this.appendDummyInput()
            .appendField(new Blockly.FieldTextInput("8"), "HOUR")
            .appendField(":")
            .appendField(new Blockly.FieldTextInput("00"), "MINUTE")
        this.appendStatementInput("STATEMENTS")
            .setCheck(null);
        this.setInputsInline(true);
        this.setColour(Blockly.Blocks.timing.HUE);
        this.setHelpUrl('help/index.html#schedule-at-trigger');
    }
};



Blockly.Blocks['expiration_timer_start'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Start Expriation Timer")
            .appendField(new Blockly.FieldTextInput("ExpirationTimer0"), "NAME")
            .appendField("Duration")
            .appendField(new Blockly.FieldTextInput("30"), "DURATION")
            .appendField("seconds");
        this.setPreviousStatement(true, null);
        this.setNextStatement(true, null);
        this.setColour(230);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};



Blockly.Blocks['expiration_timer_expired'] = {
    init: function () {
        this.appendDummyInput()
            .appendField("Expriation Timer Expired")
            .appendField(new Blockly.FieldTextInput("ExpirationTimer0"), "NAME");
        this.setOutput(true, null);
        this.setColour(230);
        this.setTooltip("");
        this.setHelpUrl("");
    }
};