/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.ast;

import com.integ.snap.ast.ASTNode;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.lexer.Token;
import java.lang.constant.Constable;

public class ASTUnaryNode
implements ASTNode {
    private final Token _operator;
    private final ASTNode _right;

    public ASTUnaryNode(Token operator, ASTNode right) {
        this._right = right;
        this._operator = operator;
    }

    @Override
    public Object evaluate() {
        Object right = this._right.evaluate();
        if (DEBUG.ON) {
            System.out.println("unary node right: " + right + " " + right.getClass());
        }
        if (!(right instanceof Number)) {
            return new Double(0.0);
        }
        Constable result = Double.NaN;
        switch (this._operator.type) {
            case 43: {
                result = (Double)this._right.evaluate();
                break;
            }
            case 45: {
                result = 0.0 - (Double)this._right.evaluate();
                break;
            }
            case 33: {
                result = right instanceof Boolean ? Boolean.valueOf((Boolean)this._right.evaluate() == false) : (right instanceof Integer ? Boolean.valueOf(0 == (Integer)this._right.evaluate()) : Boolean.valueOf(0.0 == (Double)this._right.evaluate()));
            }
        }
        if (DEBUG.ON) {
            System.out.println("ASTUnaryNode: " + this + " = " + result);
        }
        return result;
    }

    public String toString() {
        String retString = this._operator.content + this._right;
        return retString;
    }
}

