/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.utils;

import com.integpg.janoslib.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    private static final Calendar CALENDAR = Calendar.getInstance();
    private static final TimeZone TIME_ZONE = CALENDAR.getTimeZone();

    public static TimeZone getTimezone() {
        return TIME_ZONE;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static String getTimezoneID() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("z");
        return dateFormat.format(new Date());
    }

    public static long getTimezoneOffset() {
        long timeZoneOffset = TIME_ZONE.getOffset(CALENDAR.get(0), CALENDAR.get(1), CALENDAR.get(2), CALENDAR.get(5), CALENDAR.get(7), (int)DateUtils.getMillisIntoDay());
        return timeZoneOffset;
    }

    public static boolean isDaylightSavings() {
        return TIME_ZONE.inDaylightTime(CALENDAR.getTime());
    }

    public static long getStartOfDay() {
        long now = System.currentTimeMillis();
        long startOfDay = now - now % 1000L - DateUtils.getMillisIntoDay();
        return startOfDay;
    }

    public static long getStartOfHour() {
        long startOfHour = System.currentTimeMillis() - System.currentTimeMillis() % 3600000L;
        return startOfHour;
    }

    public static long getStartOfMinute() {
        long startOfMinute = System.currentTimeMillis() - System.currentTimeMillis() % 60000L;
        return startOfMinute;
    }

    public static long getMillisIntoDay() {
        return DateUtils.getMillisIntoDay(System.currentTimeMillis());
    }

    public static long getMillisIntoDay(long time) {
        CALENDAR.setTimeInMillis(time);
        long millisIntoDay = CALENDAR.get(11) * 3600000 + CALENDAR.get(12) * 60000 + CALENDAR.get(13) * 1000;
        return millisIntoDay;
    }

    public static long getTimeInDay(int hour, int minute, int second) {
        long timeInDay = 3600000L * (long)hour + 60000L * (long)minute + 1000L * (long)second;
        System.out.println("timeInDay: " + timeInDay);
        timeInDay = DateUtils.getStartOfDay() + timeInDay;
        System.out.println("timeInDay: " + timeInDay);
        return timeInDay;
    }

    public static long getTimeInDayFromString(String timeString) {
        String[] timeParts = StringUtils.split(timeString, ":");
        int hourOfDay = Integer.parseInt(timeParts[0]);
        int minutes = Integer.parseInt(timeParts[1]);
        int seconds = 2 < timeParts.length ? Integer.parseInt(timeParts[2]) : 0;
        return (hourOfDay * 3600 + minutes * 60 + seconds) * 1000;
    }
}

