/*
 * Decompiled with CFR 0.152.
 */
package com.integ.snap.triggers;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.snap.actions.Action;
import com.integ.snap.actions.ActionFactory;
import com.integ.snap.actions.Scope;
import com.integ.snap.triggers.Trigger;
import com.integ.taskerjson.messagehandlers.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import java.util.Hashtable;
import java.util.Json;

public class IntervalTrigger
extends Trigger
implements Runnable {
    private static final Hashtable<String, IntervalTrigger> IntervalTriggersByGuid = new Hashtable();
    private final Action[] _actions;
    private boolean _running = false;
    private Thread _thread = null;

    public IntervalTrigger(Scope parent, Json json) {
        super(parent, json);
        if (IntervalTriggersByGuid.containsKey(this._guid)) {
            IntervalTrigger every = IntervalTriggersByGuid.get(this._guid);
            every.stop();
        }
        Json[] actions = (Json[])this._paramsJson.get("Actions");
        this._actions = new Action[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            Json actionJson = actions[i];
            try {
                this._actions[i] = ActionFactory.getActionClass(parent, actionJson);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void execute() {
        if (!this._disabled) {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName() + ":" + this.getName());
            this._thread.setDaemon(true);
            this._thread.start();
        }
    }

    private void stop() {
        if (null != this._thread) {
            try {
                AppLog.info("stopping " + this._name);
                this._thread.interrupt();
                this._thread.join();
            }
            catch (InterruptedException ex) {
            }
            catch (Exception ex) {
                Throwable throwable = new Exception("error stopping interval: " + this._name).initCause(ex);
                ErrorMessage errorMessage = new ErrorMessage(throwable);
                MessagePumpEngine.postMessage(errorMessage.build());
                AppLog.error(throwable);
            }
        }
    }

    @Override
    public void run() {
        try {
            this._running = true;
            IntervalTriggersByGuid.put(this._guid, this);
            double seconds = this.getDoubleParam("Seconds");
            long nextExecute = System.currentTimeMillis();
            block2: while (true) {
                long sleepDuration;
                if (1L > (sleepDuration = nextExecute - System.currentTimeMillis())) {
                    sleepDuration = 1L;
                }
                Thread.sleep(sleepDuration);
                nextExecute += (long)((int)(seconds * 1000.0));
                TRIGGER_LOG.info(this.getName() + " process interval trigger");
                Action[] actionArray = this._actions;
                int n = actionArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    Action action = actionArray[n2];
                    action.execute();
                    ++n2;
                }
                break;
            }
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("error executing interval" + this._name).initCause(ex);
            ErrorMessage errorMessage = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(errorMessage.build());
            AppLog.error(throwable);
            this._running = false;
            return;
        }
    }

    @Override
    public void evaluate() throws Throwable {
        if (!this._running) {
            this.execute();
        }
    }
}

